/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.misc.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GunEnergyFactory {
    public static GunConfiguration getZOMGConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 10;
        config.reloadSoundEnd = false;
        config.firingDuration = 0;
        config.durability = 100000;
        config.reloadType = 1;
        config.ammoCap = 1000;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_ARROWS;
        config.firingSound = HBMSoundHandler.zomgShoot;
        config.reloadSound = HBMSoundHandler.b92Reload;
        config.name = "EMC101 Prismatic Negative Energy Cannon";
        config.manufacturer = "MWT Prototype Labs";
        config.comment.add("Taste the rainbow!");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.ZOMG_BOLT);
        return config;
    }

    public static GunConfiguration getEMPConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 30;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 0;
        config.durability = 1500;
        config.reloadType = 0;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_SPLIT;
        config.firingSound = HBMSoundHandler.teslaShoot;
        config.name = "EMP Orb Projector";
        config.manufacturer = "MWT Prototype Labs";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.SPECIAL_EMP);
        return config;
    }

    public static BulletConfiguration getOrbusConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.gun_emp_ammo;
        bullet.velocity = 1.0f;
        bullet.spread = 0.0f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 12.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = 11;
        bullet.plink = 0;
        bullet.emp = 10;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(MobEffects.field_76421_d, 200, 1));
        bullet.effects.add(new PotionEffect(MobEffects.field_76437_t, 200, 4));
        return bullet;
    }

    public static GunConfiguration getFlamerConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.reloadSoundEnd = false;
        config.firingDuration = 0;
        config.ammoCap = 100;
        config.durability = 1000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.firingSound = HBMSoundHandler.flamethrowerShoot;
        config.reloadSound = HBMSoundHandler.flamerReload;
        config.name = "Heavy Duty Flamer";
        config.manufacturer = "MWT Prototype Labs";
        config.comment.add("Dragon-slaying: Advanced techniques, part 1:");
        config.comment.add("Try not to get eaten by the dragon.");
        config.comment.add("");
        config.comment.add("Hope that helps.");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.FLAMER_NORMAL);
        config.config.add(BulletConfigSyncingUtil.FLAMER_NAPALM);
        config.config.add(BulletConfigSyncingUtil.FLAMER_WP);
        config.config.add(BulletConfigSyncingUtil.FLAMER_VAPORIZER);
        config.config.add(BulletConfigSyncingUtil.FLAMER_GAS);
        return config;
    }

    public static GunConfiguration getVortexConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 30;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.hasSights = false;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 10;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.NONE;
        config.durability = 10000;
        config.reloadSound = GunConfiguration.RSOUND_MAG;
        config.firingSound = HBMSoundHandler.hksShoot;
        config.reloadSoundEnd = false;
        config.name = "Visual Operation Ranged Tactical Electromagnetic Xenoblaster";
        config.manufacturer = "Xon Corporation";
        config.comment.add("OBEY XON");
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("VORTEX_RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 1.0, -5.0, 25)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 400))));
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.R556_STAR);
        return config;
    }

    public static GunConfiguration getCCPlasmaGunConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 2;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.hasSights = false;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 40;
        config.reloadType = 0;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.NONE;
        config.durability = 10000;
        config.reloadSound = GunConfiguration.RSOUND_MAG;
        config.firingSound = HBMSoundHandler.osiprShoot;
        config.reloadSoundEnd = false;
        config.name = "ChickenCom Light Duty Plasma Gun";
        config.manufacturer = "ChickenCom";
        config.comment.add("A gun originally manufactured for a lesser species.");
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 1.0, -5.0, 25)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))));
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.R556_NORMAL);
        config.config.add(BulletConfigSyncingUtil.R556_GOLD);
        config.config.add(BulletConfigSyncingUtil.R556_TRACER);
        config.config.add(BulletConfigSyncingUtil.R556_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.R556_AP);
        config.config.add(BulletConfigSyncingUtil.R556_DU);
        config.config.add(BulletConfigSyncingUtil.R556_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_R556);
        config.config.add(BulletConfigSyncingUtil.R556_SLEEK);
        config.config.add(BulletConfigSyncingUtil.R556_K);
        return config;
    }

    public static GunConfiguration getEgonConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 2;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.hasSights = false;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 40;
        config.reloadType = 0;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.NONE;
        config.durability = 10000;
        config.reloadSound = GunConfiguration.RSOUND_MAG;
        config.firingSound = HBMSoundHandler.osiprShoot;
        config.reloadSoundEnd = false;
        config.name = "Gluon Gun";
        config.manufacturer = "Black Mesa Research Facility";
        config.comment.add("Damage starts at 5/s and gets doubled every 2s while on target");
        config.comment.add("Working to make a better tomorrow for all mankind.");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.SPECIAL_GAUSS);
        return config;
    }

    public static BulletConfiguration getFlameConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.ammo_fuel;
        bullet.ammoCount = 100;
        bullet.velocity = 0.75f;
        bullet.spread = 0.025f;
        bullet.wear = 1;
        bullet.bulletsMin = 3;
        bullet.bulletsMax = 5;
        bullet.dmgMin = 2.0f;
        bullet.dmgMax = 4.0f;
        bullet.gravity = 0.01;
        bullet.maxAge = 60;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = -1;
        bullet.plink = 0;
        bullet.vPFX = "flame";
        bullet.incendiary = 10;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "flame");
                data.func_74768_a("count", 15);
                data.func_74780_a("motion", 0.1);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNapalmConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = ModItems.ammo_fuel_napalm;
        bullet.wear = 2;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 6.0f;
        bullet.maxAge = 200;
        return bullet;
    }

    public static BulletConfiguration getPhosphorusConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = ModItems.ammo_fuel_phosphorus;
        bullet.wear = 2;
        bullet.spread = 0.0f;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 6.0f;
        bullet.maxAge = 200;
        bullet.vPFX = "smoke";
        bullet.bImpact = BulletConfigFactory.getPhosphorousEffect(5, 1200, 25, 0.25, 0.1f);
        return bullet;
    }

    public static BulletConfiguration getVaporizerConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = ModItems.ammo_fuel_vaporizer;
        bullet.wear = 4;
        bullet.spread = 0.25f;
        bullet.bulletsMin = 8;
        bullet.bulletsMax = 10;
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 10.0f;
        bullet.maxAge = 15;
        bullet.vPFX = "flame";
        bullet.incendiary = 0;
        PotionEffect eff = new PotionEffect((Potion)HbmPotion.phosphorus, 400, 0, true, false);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        return bullet;
    }

    public static BulletConfiguration getGasConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = ModItems.ammo_fuel_gas;
        bullet.wear = 1;
        bullet.spread = 0.05f;
        bullet.gravity = 0.0;
        bullet.bulletsMin = 5;
        bullet.bulletsMax = 7;
        bullet.dmgMin = 0.0f;
        bullet.dmgMax = 0.0f;
        bullet.vPFX = "cloud";
        bullet.incendiary = 0;
        bullet.bImpact = BulletConfigFactory.getGasEffect(5, 1200);
        return bullet;
    }

    public static BulletConfiguration getZOMGBoltConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.nugget_euphemium;
        bullet.ammoCount = 1000;
        bullet.wear = 1;
        bullet.velocity = 1.0f;
        bullet.spread = 0.125f;
        bullet.maxAge = 100;
        bullet.gravity = 0.0;
        bullet.bulletsMin = 5;
        bullet.bulletsMax = 5;
        bullet.dmgMin = 10000.0f;
        bullet.dmgMax = 25000.0f;
        bullet.style = 3;
        bullet.trail = 3;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect((Potion)HbmPotion.bang, 200, 0));
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (!bullet.field_70170_p.field_72995_K) {
                    ExplosionChaos.explodeZOMG(bullet.field_70170_p, (int)bullet.field_70165_t, (int)bullet.field_70163_u, (int)bullet.field_70161_v, 5);
                    bullet.field_70170_p.func_184148_a(null, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, HBMSoundHandler.bombDet, SoundCategory.HOSTILE, 5.0f, 1.0f);
                    ExplosionLarge.spawnParticles(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 5);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getTurretConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.spread *= 2.0f;
        bullet.gravity = 0.0025;
        return bullet;
    }
}

