/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.particle.EntityBSmokeFX;
import com.hbm.entity.projectile.EntityBoxcar;
import com.hbm.entity.projectile.EntityBuilding;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.entity.projectile.EntityDuchessGambit;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletHitBehavior;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.render.misc.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Gun44MagnumFactory {
    public static GunConfiguration getBaseConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 10;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 6;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CLASSIC;
        config.reloadSound = GunConfiguration.RSOUND_REVOLVER;
        config.firingSound = HBMSoundHandler.revolverShootAlt;
        config.reloadSoundEnd = false;
        return config;
    }

    public static GunConfiguration getNovacConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 2500;
        config.name = "IF-18 Horseshoe";
        config.manufacturer = "Ironshod Firearms";
        config.comment.add("Fallout New Vegas wasn't THAT good.");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.M44_NORMAL);
        config.config.add(BulletConfigSyncingUtil.M44_AP);
        config.config.add(BulletConfigSyncingUtil.M44_DU);
        config.config.add(BulletConfigSyncingUtil.M44_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.M44_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_M44);
        config.config.add(BulletConfigSyncingUtil.M44_ROCKET);
        return config;
    }

    public static GunConfiguration getMacintoshConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 4000;
        config.name = "IF-18 Horseshoe Scoped";
        config.manufacturer = "Ironshod Firearms";
        config.comment.add("Poppin' mentats like tic tacs");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.M44_PIP);
        config.config.add(BulletConfigSyncingUtil.M44_NORMAL);
        config.config.add(BulletConfigSyncingUtil.M44_AP);
        config.config.add(BulletConfigSyncingUtil.M44_DU);
        config.config.add(BulletConfigSyncingUtil.M44_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.M44_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_M44);
        config.config.add(BulletConfigSyncingUtil.M44_ROCKET);
        return config;
    }

    public static GunConfiguration getBlackjackConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 4000;
        config.ammoCap = 5;
        config.name = "IF-18 Horseshoe Vanity";
        config.manufacturer = "Ironshod Firearms";
        config.comment.add("Alcoholism is cool!");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.M44_BJ);
        config.config.add(BulletConfigSyncingUtil.M44_NORMAL);
        config.config.add(BulletConfigSyncingUtil.M44_AP);
        config.config.add(BulletConfigSyncingUtil.M44_DU);
        config.config.add(BulletConfigSyncingUtil.M44_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.M44_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_M44);
        config.config.add(BulletConfigSyncingUtil.M44_ROCKET);
        return config;
    }

    public static GunConfiguration getSilverConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 4000;
        config.ammoCap = 6;
        config.name = "IF-18 Horseshoe Silver Storm";
        config.manufacturer = "Ironshod Firearms";
        config.comment.add("Our friendship is based on abusive behaviour");
        config.comment.add("and mutual hate. It's not that complicated.");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.M44_SILVER);
        config.config.add(BulletConfigSyncingUtil.M44_NORMAL);
        config.config.add(BulletConfigSyncingUtil.M44_AP);
        config.config.add(BulletConfigSyncingUtil.M44_DU);
        config.config.add(BulletConfigSyncingUtil.M44_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.M44_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_M44);
        config.config.add(BulletConfigSyncingUtil.M44_ROCKET);
        return config;
    }

    public static GunConfiguration getRedConfig() {
        GunConfiguration config = Gun44MagnumFactory.getBaseConfig();
        config.durability = 4000;
        config.ammoCap = 64;
        config.name = "IF-18 Horseshoe Bottomless Pit";
        config.manufacturer = "Ironshod Firearms R&D";
        config.comment.add("Explore the other side");
        config.comment.add("...from afar!");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.M44_NORMAL);
        config.config.add(BulletConfigSyncingUtil.M44_AP);
        config.config.add(BulletConfigSyncingUtil.M44_DU);
        config.config.add(BulletConfigSyncingUtil.M44_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_M44);
        config.config.add(BulletConfigSyncingUtil.M44_PIP);
        config.config.add(BulletConfigSyncingUtil.M44_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.M44_BJ);
        config.config.add(BulletConfigSyncingUtil.M44_SILVER);
        config.config.add(BulletConfigSyncingUtil.M44_ROCKET);
        return config;
    }

    public static BulletConfiguration getNoPipConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_44;
        bullet.dmgMin = 5.0f;
        bullet.dmgMax = 7.0f;
        return bullet;
    }

    public static BulletConfiguration getNoPipAPConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_44_ap;
        bullet.dmgMin = 7.0f;
        bullet.dmgMax = 10.0f;
        bullet.wear = 15;
        bullet.leadChance = 10;
        return bullet;
    }

    public static BulletConfiguration getNoPipDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_44_du;
        bullet.dmgMin = 7.0f;
        bullet.dmgMax = 10.0f;
        bullet.wear = 25;
        bullet.leadChance = 50;
        return bullet;
    }

    public static BulletConfiguration getNoPipStarConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_44_star;
        bullet.dmgMin = 14.0f;
        bullet.dmgMax = 20.0f;
        bullet.wear = 25;
        bullet.leadChance = 100;
        return bullet;
    }

    public static BulletConfiguration getPipConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_44_pip;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 5.0f;
        bullet.wear = 25;
        bullet.doesPenetrate = false;
        bullet.bHit = new IBulletHitBehavior(){

            @Override
            public void behaveEntityHit(EntityBulletBase bullet, Entity hit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    EntityBoxcar pippo = new EntityBoxcar(bullet.field_70170_p);
                    pippo.field_70165_t = hit.field_70165_t;
                    pippo.field_70163_u = hit.field_70163_u + 50.0;
                    pippo.field_70161_v = hit.field_70161_v;
                    for (int j = 0; j < 50; ++j) {
                        EntityBSmokeFX fx = new EntityBSmokeFX(bullet.field_70170_p, pippo.field_70165_t + (bullet.field_70170_p.field_73012_v.nextDouble() - 0.5) * 4.0, pippo.field_70163_u + (bullet.field_70170_p.field_73012_v.nextDouble() - 0.5) * 12.0, pippo.field_70161_v + (bullet.field_70170_p.field_73012_v.nextDouble() - 0.5) * 4.0, 0.0, 0.0, 0.0);
                        bullet.field_70170_p.func_72838_d((Entity)fx);
                    }
                    bullet.field_70170_p.func_72838_d((Entity)pippo);
                    bullet.field_70170_p.func_184148_a(null, pippo.field_70165_t, pippo.field_70163_u + 50.0, pippo.field_70161_v, HBMSoundHandler.trainHorn, SoundCategory.PLAYERS, 100.0f, 1.0f);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getBJConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_44_bj;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 5.0f;
        bullet.wear = 25;
        bullet.doesPenetrate = false;
        bullet.bHit = new IBulletHitBehavior(){

            @Override
            public void behaveEntityHit(EntityBulletBase bullet, Entity hit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    EntityDuchessGambit pippo = new EntityDuchessGambit(bullet.field_70170_p);
                    pippo.field_70165_t = hit.field_70165_t;
                    pippo.field_70163_u = hit.field_70163_u + 50.0;
                    pippo.field_70161_v = hit.field_70161_v;
                    for (int j = 0; j < 150; ++j) {
                        EntityBSmokeFX fx = new EntityBSmokeFX(bullet.field_70170_p, pippo.field_70165_t + (bullet.field_70170_p.field_73012_v.nextDouble() - 0.5) * 7.0, pippo.field_70163_u + (bullet.field_70170_p.field_73012_v.nextDouble() - 0.5) * 8.0, pippo.field_70161_v + (bullet.field_70170_p.field_73012_v.nextDouble() - 0.5) * 18.0, 0.0, 0.0, 0.0);
                        bullet.field_70170_p.func_72838_d((Entity)fx);
                    }
                    bullet.field_70170_p.func_72838_d((Entity)pippo);
                    bullet.field_70170_p.func_184148_a(null, pippo.field_70165_t, pippo.field_70163_u + 50.0, pippo.field_70161_v, HBMSoundHandler.boatWeapon, SoundCategory.PLAYERS, 100.0f, 1.0f);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getSilverStormConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_44_silver;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 5.0f;
        bullet.wear = 25;
        bullet.doesPenetrate = false;
        bullet.bHit = new IBulletHitBehavior(){

            @Override
            public void behaveEntityHit(EntityBulletBase bullet, Entity hit) {
                if (!bullet.field_70170_p.field_72995_K) {
                    EntityBuilding pippo = new EntityBuilding(bullet.field_70170_p);
                    pippo.field_70165_t = hit.field_70165_t;
                    pippo.field_70163_u = hit.field_70163_u + 50.0;
                    pippo.field_70161_v = hit.field_70161_v;
                    for (int j = 0; j < 150; ++j) {
                        EntityBSmokeFX fx = new EntityBSmokeFX(bullet.field_70170_p, pippo.field_70165_t + (bullet.field_70170_p.field_73012_v.nextDouble() - 0.5) * 15.0, pippo.field_70163_u + (bullet.field_70170_p.field_73012_v.nextDouble() - 0.5) * 15.0, pippo.field_70161_v + (bullet.field_70170_p.field_73012_v.nextDouble() - 0.5) * 15.0, 0.0, 0.0, 0.0);
                        bullet.field_70170_p.func_72838_d((Entity)fx);
                    }
                    bullet.field_70170_p.func_72838_d((Entity)pippo);
                    bullet.field_70170_p.func_184148_a(null, pippo.field_70165_t, pippo.field_70163_u + 50.0, pippo.field_70161_v, HBMSoundHandler.blockDebris, SoundCategory.PLAYERS, 100.0f, 1.0f);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getRocketConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = ModItems.ammo_44_rocket;
        bullet.velocity = 5.0f;
        bullet.explosive = 15.0f;
        bullet.trail = 1;
        return bullet;
    }

    public static BulletConfiguration getPhosphorusConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_44_phosphorus;
        bullet.dmgMin = 5.0f;
        bullet.dmgMax = 7.0f;
        bullet.wear = 15;
        bullet.incendiary = 5;
        bullet.doesPenetrate = false;
        PotionEffect eff = new PotionEffect((Potion)HbmPotion.phosphorus, 400, 0, true, false);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "flame");
                data.func_74768_a("count", 15);
                data.func_74780_a("motion", 0.05);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
            }
        };
        return bullet;
    }
}

