/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.blocks.ModBlocks;
import com.hbm.main.MainRegistry;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.io.IOUtils;

public class MultiblockBBHandler {
    public static final MultiblockBounds FENSU_BOUNDS = MultiblockBBHandler.load(new ResourceLocation("hbm", "multiblock_bounds/bb_fensu0.mbb"));
    public static final Map<Block, MultiblockBounds> REGISTRY = new HashMap<Block, MultiblockBounds>();

    public static MultiblockBounds load(ResourceLocation loc) {
        try {
            InputStream s = MainRegistry.class.getResourceAsStream("/assets/" + loc.func_110624_b() + "/" + loc.func_110623_a());
            return MultiblockBBHandler.parse(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)s)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static MultiblockBounds parse(ByteBuffer buf) {
        int i;
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int version = buf.getInt();
        int offsetX = buf.getInt();
        int offsetY = buf.getInt();
        int offsetZ = buf.getInt();
        AxisAlignedBB[] boundingBoxes = new AxisAlignedBB[buf.getInt()];
        int numBlocks = buf.getInt();
        HashMap<BlockPos, AxisAlignedBB[]> blocks = new HashMap<BlockPos, AxisAlignedBB[]>();
        for (i = 0; i < boundingBoxes.length; ++i) {
            boundingBoxes[i] = new AxisAlignedBB((double)buf.getFloat(), (double)buf.getFloat(), (double)buf.getFloat(), (double)buf.getFloat(), (double)buf.getFloat(), (double)buf.getFloat());
        }
        for (i = 0; i < numBlocks; ++i) {
            BlockPos pos = new BlockPos((double)buf.getFloat(), (double)buf.getFloat(), (double)buf.getFloat());
            AxisAlignedBB[] blockBoxes = new AxisAlignedBB[buf.getInt()];
            for (int j = 0; j < blockBoxes.length; ++j) {
                blockBoxes[j] = new AxisAlignedBB((double)buf.getFloat(), (double)buf.getFloat(), (double)buf.getFloat(), (double)buf.getFloat(), (double)buf.getFloat(), (double)buf.getFloat());
            }
            blocks.put(pos, blockBoxes);
        }
        return new MultiblockBounds(boundingBoxes, blocks);
    }

    public static void init() {
        REGISTRY.put(ModBlocks.machine_fensu, FENSU_BOUNDS);
    }

    public static class MultiblockBounds {
        public AxisAlignedBB[] boxes;
        public Map<BlockPos, AxisAlignedBB[]> blocks;

        public MultiblockBounds(AxisAlignedBB[] boxes, Map<BlockPos, AxisAlignedBB[]> blocks) {
            this.boxes = boxes;
            this.blocks = blocks;
        }
    }
}

