/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.config.GeneralConfig;
import com.hbm.main.ClientProxy;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.particle_instanced.InstancedParticleRenderer;
import com.hbm.render.GLCompat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class HbmShaderManager2 {
    public static final FloatBuffer AUX_GL_BUFFER = GLAllocation.func_74529_h((int)16);
    public static final Shader.Uniform MODELVIEW_PROJECTION_MATRIX = shader -> {
        GL11.glGetFloat((int)2982, (FloatBuffer)AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        Matrix4f mvMatrix = new Matrix4f();
        mvMatrix.load(AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        GL11.glGetFloat((int)2983, (FloatBuffer)AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        Matrix4f pMatrix = new Matrix4f();
        pMatrix.load(AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        Matrix4f.mul((Matrix4f)pMatrix, (Matrix4f)mvMatrix, (Matrix4f)mvMatrix).store(AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        shader.uniformMatrix4("modelViewProjectionMatrix", false, AUX_GL_BUFFER);
    };
    public static final Shader.Uniform MODELVIEW_MATRIX = shader -> {
        GL11.glGetFloat((int)2982, (FloatBuffer)AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        shader.uniformMatrix4("modelview", false, AUX_GL_BUFFER);
    };
    public static final Shader.Uniform PROJECTION_MATRIX = shader -> {
        GL11.glGetFloat((int)2983, (FloatBuffer)AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        shader.uniformMatrix4("projection", false, AUX_GL_BUFFER);
    };
    public static final Shader.Uniform INV_PLAYER_ROT_MATRIX = shader -> {
        Entity entityIn = Minecraft.func_71410_x().func_175606_aa();
        float partialTicks = InstancedParticleRenderer.partialTicks;
        float yaw = entityIn.field_70126_B + (entityIn.field_70177_z - entityIn.field_70126_B) * partialTicks;
        float pitch = entityIn.field_70127_C + (entityIn.field_70125_A - entityIn.field_70127_C) * partialTicks;
        Matrix4f mat = new Matrix4f();
        mat.rotate((float)Math.toRadians(-yaw + 180.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        mat.rotate((float)Math.toRadians(-pitch), new Vector3f(1.0f, 0.0f, 0.0f));
        mat.store(AUX_GL_BUFFER);
        AUX_GL_BUFFER.rewind();
        shader.uniformMatrix4("invPlayerRot", false, AUX_GL_BUFFER);
    };
    public static final Shader.Uniform LIGHTMAP = shader -> shader.uniform1i("lightmap", 1);
    public static final Shader.Uniform WINDOW_SIZE = shader -> shader.uniform2f("windowSize", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
    public static int height = 0;
    public static int width = 0;
    public static final int bloomLayers = 4;
    public static Framebuffer[] bloomBuffers;
    public static Framebuffer bloomData;
    public static Framebuffer distortionBuffer;
    public static int depthFrameBuffer;
    public static int depthTexture;
    public static float[] inv_ViewProjectionMatrix;
    public static Framebuffer buf;

    public static void createInvMVP() {
        GL11.glPushMatrix();
        GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
        GL11.glPopMatrix();
        GL11.glGetFloat((int)2983, (FloatBuffer)ClientProxy.AUX_GL_BUFFER2);
        Matrix4f view = new Matrix4f();
        Matrix4f proj = new Matrix4f();
        view.load(ClientProxy.AUX_GL_BUFFER);
        proj.load(ClientProxy.AUX_GL_BUFFER2);
        ClientProxy.AUX_GL_BUFFER.rewind();
        ClientProxy.AUX_GL_BUFFER2.rewind();
        view.invert();
        proj.invert();
        Matrix4f.mul((Matrix4f)view, (Matrix4f)proj, (Matrix4f)view);
        view.store(ClientProxy.AUX_GL_BUFFER);
        ClientProxy.AUX_GL_BUFFER.rewind();
        ClientProxy.AUX_GL_BUFFER.get(inv_ViewProjectionMatrix);
        ClientProxy.AUX_GL_BUFFER.rewind();
    }

    public static void blitDepth() {
        if (!GeneralConfig.depthEffects) {
            return;
        }
        if (height != Minecraft.func_71410_x().field_71440_d || width != Minecraft.func_71410_x().field_71443_c || depthFrameBuffer == -1) {
            GL11.glDeleteTextures((int)depthTexture);
            GLCompat.deleteFramebuffers(depthFrameBuffer);
            depthFrameBuffer = GLCompat.genFramebuffers();
            GLCompat.bindFramebuffer(OpenGlHelper.field_153198_e, depthFrameBuffer);
            depthTexture = GL11.glGenTextures();
            GlStateManager.func_179144_i((int)depthTexture);
            GL11.glTexImage2D((int)3553, (int)0, (int)33190, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d, (int)0, (int)6402, (int)5126, (FloatBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLCompat.framebufferTexture2D(OpenGlHelper.field_153198_e, OpenGlHelper.field_153201_h, 3553, depthTexture, 0);
            int bruh = OpenGlHelper.func_153167_i((int)OpenGlHelper.field_153198_e);
            if (bruh != OpenGlHelper.field_153202_i) {
                System.out.println("Failed to create depth texture framebuffer! This is an error!");
            }
        }
        GLCompat.bindFramebuffer(GLCompat.GL_READ_FRAMEBUFFER, Minecraft.func_71410_x().func_147110_a().field_147616_f);
        GLCompat.bindFramebuffer(GLCompat.GL_DRAW_FRAMEBUFFER, depthFrameBuffer);
        GLCompat.blitFramebuffer(0, 0, width, height, 0, 0, width, height, 256, 9728);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
    }

    public static void postProcess() {
        if (!GeneralConfig.useShaders2) {
            return;
        }
        if (height != Minecraft.func_71410_x().field_71440_d || width != Minecraft.func_71410_x().field_71443_c) {
            height = Minecraft.func_71410_x().field_71440_d;
            width = Minecraft.func_71410_x().field_71443_c;
            if (GeneralConfig.bloom) {
                HbmShaderManager2.recreateBloomFBOs();
            }
            if (GeneralConfig.heatDistortion) {
                HbmShaderManager2.recreateDistortionBuffer();
            }
        }
        if (GeneralConfig.bloom) {
            HbmShaderManager2.bloom();
        }
        if (GeneralConfig.heatDistortion) {
            HbmShaderManager2.heatDistortion();
        }
        GlStateManager.func_179126_j();
    }

    private static void heatDistortion() {
        GL11.glFlush();
        ResourceManager.heat_distortion_post.use();
        GlStateManager.func_179138_g((int)(GLCompat.GL_TEXTURE0 + 3));
        GLCompat.activeTexture(GLCompat.GL_TEXTURE0 + 3);
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147110_a().field_147617_g);
        GL11.glBindTexture((int)3553, (int)Minecraft.func_71410_x().func_147110_a().field_147617_g);
        GLCompat.uniform1i(GLCompat.getUniformLocation(ResourceManager.heat_distortion_post.getShaderId(), "mc_tex"), 3);
        GlStateManager.func_179138_g((int)GLCompat.GL_TEXTURE0);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        HbmShaderManager2.renderFboTriangle(distortionBuffer);
        HbmShaderManager2.releaseShader();
        distortionBuffer.func_147610_a(true);
        GlStateManager.func_179082_a((float)HbmShaderManager2.distortionBuffer.field_147625_i[0], (float)HbmShaderManager2.distortionBuffer.field_147625_i[1], (float)HbmShaderManager2.distortionBuffer.field_147625_i[2], (float)HbmShaderManager2.distortionBuffer.field_147625_i[3]);
        GlStateManager.func_179086_m((int)16384);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
    }

    public static void distort(float strength, Runnable render) {
        distortionBuffer.func_147610_a(false);
        ResourceManager.heat_distortion_new.use();
        GLCompat.uniform1f(GLCompat.getUniformLocation(ResourceManager.heat_distortion_new.getShaderId(), "amount"), strength);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        render.run();
        GlStateManager.func_179084_k();
        HbmShaderManager2.releaseShader();
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
    }

    private static void bloom() {
        HbmShaderManager2.downsampleBloomData();
        GlStateManager.func_179147_l();
        for (int i = 3; i >= 0; --i) {
            int tHeight;
            int tWidth;
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            bloomBuffers[i * 2 + 1].func_147610_a(true);
            ResourceManager.bloom_h.use();
            GLCompat.uniform1f(GLCompat.getUniformLocation(ResourceManager.bloom_h.getShaderId(), "frag_width"), 1.0f / (float)HbmShaderManager2.bloomBuffers[i * 2].field_147621_c);
            HbmShaderManager2.renderFboTriangle(bloomBuffers[i * 2], HbmShaderManager2.bloomBuffers[i * 2 + 1].field_147621_c, HbmShaderManager2.bloomBuffers[i * 2 + 1].field_147618_d);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            if (i == 0) {
                Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
                tWidth = Minecraft.func_71410_x().func_147110_a().field_147621_c;
                tHeight = Minecraft.func_71410_x().func_147110_a().field_147618_d;
            } else {
                GLCompat.blendEquation(GLCompat.GL_MAX);
                bloomBuffers[(i - 1) * 2].func_147610_a(true);
                tWidth = HbmShaderManager2.bloomBuffers[(i - 1) * 2].field_147621_c;
                tHeight = HbmShaderManager2.bloomBuffers[(i - 1) * 2].field_147618_d;
            }
            ResourceManager.bloom_v.use();
            GLCompat.uniform1f(GLCompat.getUniformLocation(ResourceManager.bloom_v.getShaderId(), "frag_height"), 1.0f / (float)HbmShaderManager2.bloomBuffers[i * 2].field_147618_d);
            HbmShaderManager2.renderFboTriangle(bloomBuffers[i * 2 + 1], tWidth, tHeight);
            GLCompat.blendEquation(GLCompat.GL_FUNC_ADD);
        }
        HbmShaderManager2.releaseShader();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        bloomData.func_147610_a(true);
        GlStateManager.func_179082_a((float)HbmShaderManager2.bloomData.field_147625_i[0], (float)HbmShaderManager2.bloomData.field_147625_i[1], (float)HbmShaderManager2.bloomData.field_147625_i[2], (float)HbmShaderManager2.bloomData.field_147625_i[3]);
        GlStateManager.func_179086_m((int)16384);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public static void downsampleBloomData() {
        bloomBuffers[0].func_147610_a(true);
        ResourceManager.downsample.use();
        GLCompat.uniform2f(GLCompat.getUniformLocation(ResourceManager.downsample.getShaderId(), "texel"), 1.0f / (float)HbmShaderManager2.bloomData.field_147622_a, 1.0f / (float)HbmShaderManager2.bloomData.field_147620_b);
        HbmShaderManager2.renderFboTriangle(bloomData, HbmShaderManager2.bloomBuffers[0].field_147621_c, HbmShaderManager2.bloomBuffers[0].field_147618_d);
        for (int i = 1; i < 4; ++i) {
            bloomBuffers[i * 2].func_147610_a(true);
            GLCompat.uniform2f(GLCompat.getUniformLocation(ResourceManager.downsample.getShaderId(), "texel"), 1.0f / (float)HbmShaderManager2.bloomBuffers[(i - 1) * 2].field_147622_a, 1.0f / (float)HbmShaderManager2.bloomBuffers[(i - 1) * 2].field_147620_b);
            HbmShaderManager2.renderFboTriangle(bloomBuffers[(i - 1) * 2], HbmShaderManager2.bloomBuffers[i * 2].field_147621_c, HbmShaderManager2.bloomBuffers[i * 2].field_147618_d);
        }
        HbmShaderManager2.releaseShader();
    }

    public static void recreateDistortionBuffer() {
        if (distortionBuffer != null) {
            distortionBuffer.func_147608_a();
        }
        distortionBuffer = new Framebuffer(width, height, true);
        distortionBuffer.func_147612_c();
        GL11.glTexImage2D((int)3553, (int)0, (int)GLCompat.GL_RGBA16F, (int)width, (int)height, (int)0, (int)6408, (int)5123, (IntBuffer)null);
        distortionBuffer.func_147610_a(false);
        GLCompat.bindRenderbuffer(GLCompat.GL_RENDERBUFFER, Minecraft.func_71410_x().func_147110_a().field_147624_h);
        OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)OpenGlHelper.field_153199_f, (int)Minecraft.func_71410_x().func_147110_a().field_147624_h);
        distortionBuffer.func_147607_a(9729);
        distortionBuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        distortionBuffer.func_147614_f();
    }

    public static void recreateBloomFBOs() {
        if (bloomBuffers != null) {
            for (Framebuffer buf : bloomBuffers) {
                buf.func_147608_a();
            }
        }
        if (bloomData != null) {
            bloomData.func_147608_a();
        }
        bloomData = new Framebuffer(width, height, true);
        bloomData.func_147612_c();
        GL11.glTexImage2D((int)3553, (int)0, (int)GLCompat.GL_RGBA16F, (int)width, (int)height, (int)0, (int)6408, (int)5123, (IntBuffer)null);
        bloomData.func_147610_a(false);
        GLCompat.bindRenderbuffer(GLCompat.GL_RENDERBUFFER, Minecraft.func_71410_x().func_147110_a().field_147624_h);
        GLCompat.framebufferRenderbuffer(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_DEPTH_ATTACHMENT, GLCompat.GL_RENDERBUFFER, Minecraft.func_71410_x().func_147110_a().field_147624_h);
        bloomData.func_147607_a(9729);
        bloomData.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        bloomData.func_147614_f();
        bloomBuffers = new Framebuffer[8];
        float bloomW = width;
        float bloomH = height;
        for (int i = 0; i < 4; ++i) {
            HbmShaderManager2.bloomBuffers[i * 2] = new Framebuffer((int)bloomW, (int)bloomH, false);
            HbmShaderManager2.bloomBuffers[i * 2 + 1] = new Framebuffer((int)bloomW, (int)bloomH, false);
            bloomBuffers[i * 2].func_147612_c();
            GL11.glTexImage2D((int)3553, (int)0, (int)GLCompat.GL_RGBA16F, (int)((int)bloomW), (int)((int)bloomH), (int)0, (int)6408, (int)5123, (IntBuffer)null);
            bloomBuffers[i * 2 + 1].func_147612_c();
            GL11.glTexImage2D((int)3553, (int)0, (int)GLCompat.GL_RGBA16F, (int)((int)bloomW), (int)((int)bloomH), (int)0, (int)6408, (int)5123, (IntBuffer)null);
            bloomBuffers[i * 2].func_147607_a(9729);
            bloomBuffers[i * 2 + 1].func_147607_a(9729);
            bloomBuffers[i * 2].func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
            bloomBuffers[i * 2 + 1].func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
            if (i < 2) {
                bloomW *= 0.25f;
                bloomH *= 0.25f;
                continue;
            }
            bloomW *= 0.5f;
            bloomH *= 0.5f;
        }
    }

    public static void renderFboTriangle(Framebuffer buf) {
        HbmShaderManager2.renderFboTriangle(buf, buf.field_147621_c, buf.field_147618_d);
    }

    public static void renderFboTriangle(Framebuffer buf, int width, int height) {
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179083_b((int)0, (int)0, (int)width, (int)height);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        GlStateManager.func_179142_g();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buf.func_147612_c();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-1.0, -1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(3.0, -1.0, 0.0).func_187315_a(2.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, 3.0, 0.0).func_187315_a(0.0, 2.0).func_181675_d();
        tessellator.func_78381_a();
        buf.func_147606_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static Shader loadShader(ResourceLocation file) {
        return HbmShaderManager2.loadShader(file, null);
    }

    public static Shader loadShader(ResourceLocation file, Consumer<Integer> attribBinder) {
        if (!GeneralConfig.useShaders2) {
            return new Shader(0);
        }
        int vertexShader = 0;
        int fragmentShader = 0;
        try {
            int program = GLCompat.createProgram();
            vertexShader = GLCompat.createShader(GLCompat.GL_VERTEX_SHADER);
            GLCompat.shaderSource(vertexShader, HbmShaderManager2.readFileToBuf(new ResourceLocation(file.func_110624_b(), file.func_110623_a() + ".vert")));
            GLCompat.compileShader(vertexShader);
            if (GLCompat.getShaderi(vertexShader, GLCompat.GL_COMPILE_STATUS) == 0) {
                MainRegistry.logger.error(GLCompat.getShaderInfoLog(vertexShader, GLCompat.GL_INFO_LOG_LENGTH));
                throw new RuntimeException("Error creating vertex shader: " + file);
            }
            fragmentShader = GLCompat.createShader(GLCompat.GL_FRAGMENT_SHADER);
            GLCompat.shaderSource(fragmentShader, HbmShaderManager2.readFileToBuf(new ResourceLocation(file.func_110624_b(), file.func_110623_a() + ".frag")));
            GLCompat.compileShader(fragmentShader);
            if (GLCompat.getShaderi(fragmentShader, GLCompat.GL_COMPILE_STATUS) == 0) {
                MainRegistry.logger.error(GLCompat.getShaderInfoLog(fragmentShader, GLCompat.GL_INFO_LOG_LENGTH));
                throw new RuntimeException("Error creating fragment shader: " + file);
            }
            GLCompat.attachShader(program, vertexShader);
            GLCompat.attachShader(program, fragmentShader);
            if (attribBinder != null) {
                attribBinder.accept(program);
            }
            GLCompat.linkProgram(program);
            if (GLCompat.getProgrami(program, GLCompat.GL_LINK_STATUS) == 0) {
                MainRegistry.logger.error(GLCompat.getProgramInfoLog(program, GLCompat.GL_INFO_LOG_LENGTH));
                throw new RuntimeException("Error linking shader: " + file);
            }
            GLCompat.deleteShader(vertexShader);
            GLCompat.deleteShader(fragmentShader);
            return new Shader(program);
        }
        catch (Exception x) {
            GLCompat.deleteShader(vertexShader);
            GLCompat.deleteShader(fragmentShader);
            x.printStackTrace();
            return new Shader(0);
        }
    }

    private static ByteBuffer readFileToBuf(ResourceLocation file) throws IOException {
        InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(file).func_110527_b();
        byte[] bytes = IOUtils.toByteArray((InputStream)in);
        IOUtils.closeQuietly((InputStream)in);
        ByteBuffer buf = BufferUtils.createByteBuffer((int)bytes.length);
        buf.put(bytes);
        buf.rewind();
        return buf;
    }

    public static void releaseShader() {
        GLCompat.useProgram(0);
    }

    static {
        depthFrameBuffer = -1;
        depthTexture = -1;
        inv_ViewProjectionMatrix = new float[16];
    }

    public static class Shader {
        private int shader;
        private List<Uniform> uniforms = new ArrayList<Uniform>(2);

        public Shader(int shader) {
            this.shader = shader;
        }

        public Shader withUniforms(Uniform ... uniforms) {
            for (Uniform u : uniforms) {
                this.uniforms.add(u);
            }
            return this;
        }

        public void use() {
            if (this.shader == 0) {
                return;
            }
            GLCompat.useProgram(this.shader);
            for (Uniform u : this.uniforms) {
                u.apply(this);
            }
        }

        public int getShaderId() {
            return this.shader;
        }

        public void uniform1i(String name, int v0) {
            if (this.shader == 0) {
                return;
            }
            GLCompat.uniform1i(GLCompat.getUniformLocation(this.shader, name), v0);
        }

        public void uniform1f(String name, float v0) {
            if (this.shader == 0) {
                return;
            }
            GLCompat.uniform1f(GLCompat.getUniformLocation(this.shader, name), v0);
        }

        public void uniform2f(String name, float v0, float v1) {
            if (this.shader == 0) {
                return;
            }
            GLCompat.uniform2f(GLCompat.getUniformLocation(this.shader, name), v0, v1);
        }

        public void uniform3f(String name, float v0, float v1, float v2) {
            if (this.shader == 0) {
                return;
            }
            GLCompat.uniform3f(GLCompat.getUniformLocation(this.shader, name), v0, v1, v2);
        }

        public void uniform4f(String name, float v0, float v1, float v2, float v3) {
            if (this.shader == 0) {
                return;
            }
            GLCompat.uniform4f(GLCompat.getUniformLocation(this.shader, name), v0, v1, v2, v3);
        }

        public void uniformMatrix3(String name, boolean transpose, FloatBuffer matrix) {
            if (this.shader == 0) {
                return;
            }
            GLCompat.uniformMatrix3(GLCompat.getUniformLocation(this.shader, name), transpose, matrix);
        }

        public void uniformMatrix4(String name, boolean transpose, FloatBuffer matrix) {
            if (this.shader == 0) {
                return;
            }
            GLCompat.uniformMatrix4(GLCompat.getUniformLocation(this.shader, name), transpose, matrix);
        }

        public static interface Uniform {
            public void apply(Shader var1);
        }
    }
}

