/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletHitBehavior;
import com.hbm.interfaces.IBulletHurtBehavior;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.interfaces.IBulletRicochetBehavior;
import com.hbm.interfaces.IBulletUpdateBehavior;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;

public class BulletConfiguration {
    public Item ammo;
    public int ammoCount = 1;
    public float velocity;
    public float spread;
    public int wear;
    public int bulletsMin;
    public int bulletsMax;
    public float dmgMin;
    public float dmgMax;
    public double gravity;
    public int maxAge;
    public boolean doesRicochet;
    public double ricochetAngle;
    public int LBRC;
    public int HBRC;
    public double bounceMod;
    public boolean doesPenetrate;
    public boolean isSpectral;
    public boolean doesBreakGlass;
    public List<PotionEffect> effects;
    public int incendiary;
    public int emp;
    public boolean blockDamage = true;
    public float explosive;
    public double jolt;
    public int rainbow;
    public int nuke;
    public int shrapnel;
    public int chlorine;
    public int leadChance;
    public int caustic;
    public boolean boxcar;
    public boolean boat;
    public boolean destroysWood;
    public boolean destroysBlocks;
    public boolean instakill;
    public IBulletHurtBehavior bHurt;
    public IBulletHitBehavior bHit;
    public IBulletRicochetBehavior bRicochet;
    public IBulletImpactBehavior bImpact;
    public IBulletUpdateBehavior bUpdate;
    public int style;
    public int trail;
    public int plink;
    public String vPFX = "";
    public static final int STYLE_NONE = -1;
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_FLECHETTE = 1;
    public static final int STYLE_PELLET = 2;
    public static final int STYLE_BOLT = 3;
    public static final int STYLE_FOLLY = 4;
    public static final int STYLE_ROCKET = 5;
    public static final int STYLE_STINGER = 6;
    public static final int STYLE_NUKE = 7;
    public static final int STYLE_MIRV = 8;
    public static final int STYLE_GRENADE = 9;
    public static final int STYLE_BF = 10;
    public static final int STYLE_ORB = 11;
    public static final int STYLE_METEOR = 12;
    public static final int STYLE_TRACER = 13;
    public static final int STYLE_APDS = 14;
    public static final int PLINK_NONE = 0;
    public static final int PLINK_BULLET = 1;
    public static final int PLINK_GRENADE = 2;
    public static final int PLINK_ENERGY = 3;
    public static final int PLINK_SING = 4;
    public static final int BOLT_LACUNAE = 0;
    public static final int BOLT_NIGHTMARE = 1;
    public static final int BOLT_LASER = 2;
    public static final int BOLT_ZOMG = 3;
    public static final int BOLT_WORM = 4;

    public BulletConfiguration setToBolt(int trail) {
        this.style = 3;
        this.trail = trail;
        return this;
    }

    public BulletConfiguration setToFire(int duration) {
        this.incendiary = duration;
        return this;
    }

    public BulletConfiguration setToGuided() {
        this.bUpdate = BulletConfigFactory.getLaserSteering();
        this.doesRicochet = false;
        return this;
    }

    public BulletConfiguration setToHoming(Item ammo) {
        this.ammo = ammo;
        this.bUpdate = BulletConfigFactory.getHomingBehavior(200.0, 45.0);
        this.dmgMin *= 1.5f;
        this.dmgMax *= 1.5f;
        this.wear = (int)((double)this.wear * 0.5);
        this.doesRicochet = false;
        this.doesPenetrate = false;
        this.vPFX = "greendust";
        return this;
    }

    public BulletConfiguration accuracyMod(float mod) {
        this.spread *= mod;
        return this;
    }
}

