/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.items.armor.ItemArmorMod;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ArmorModHandler {
    public static final int helmet_only = 0;
    public static final int plate_only = 1;
    public static final int legs_only = 2;
    public static final int boots_only = 3;
    public static final int servos = 4;
    public static final int cladding = 5;
    public static final int kevlar = 6;
    public static final int extra = 7;
    public static final UUID[] UUIDs = new UUID[]{UUID.fromString("8d6e5c77-133e-4056-9c80-a9e42a1a0b65"), UUID.fromString("b1b7ee0e-1d14-4400-8037-f7f2e02f21ca"), UUID.fromString("30b50d2a-4858-4e5b-88d4-3e3612224238"), UUID.fromString("426ee0d0-7587-4697-aaef-4772ab202e78")};
    public static final UUID[] fixedUUIDs = new UUID[]{UUID.fromString("e572caf4-3e65-4152-bc79-c4d4048cbd29"), UUID.fromString("bed30902-8a6a-4769-9f65-2a9b67469fff"), UUID.fromString("baebf7b3-1eda-4a14-b233-068e2493e9a2"), UUID.fromString("28016c1b-d992-4324-9409-a9f9f0ffb85c")};
    public static final String MOD_COMPOUND_KEY = "ntm_armor_mods";
    public static final String MOD_SLOT_KEY = "mod_slot_";

    public static boolean isApplicable(ItemStack armor, ItemStack mod) {
        if (armor == null || mod == null) {
            return false;
        }
        if (!(armor.func_77973_b() instanceof ItemArmor)) {
            return false;
        }
        if (!(mod.func_77973_b() instanceof ItemArmorMod)) {
            return false;
        }
        EntityEquipmentSlot type = ((ItemArmor)armor.func_77973_b()).field_77881_a;
        ItemArmorMod aMod = (ItemArmorMod)mod.func_77973_b();
        return type == EntityEquipmentSlot.HEAD && aMod.helmet || type == EntityEquipmentSlot.CHEST && aMod.chestplate || type == EntityEquipmentSlot.LEGS && aMod.leggings || type == EntityEquipmentSlot.FEET && aMod.boots;
    }

    public static void applyMod(ItemStack armor, ItemStack mod) {
        NBTTagCompound nbt;
        if (mod == null || mod.func_190926_b() || armor == null || armor.func_190926_b()) {
            return;
        }
        if (!armor.func_77942_o()) {
            armor.func_77982_d(new NBTTagCompound());
        }
        if (!(nbt = armor.func_77978_p()).func_74764_b(MOD_COMPOUND_KEY)) {
            nbt.func_74782_a(MOD_COMPOUND_KEY, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound mods = nbt.func_74775_l(MOD_COMPOUND_KEY);
        ItemArmorMod aMod = (ItemArmorMod)mod.func_77973_b();
        int slot = aMod.type;
        NBTTagCompound cmp = new NBTTagCompound();
        mod.func_77955_b(cmp);
        mods.func_74782_a(MOD_SLOT_KEY + slot, (NBTBase)cmp);
    }

    public static void removeMod(ItemStack armor, int slot) {
        NBTTagCompound nbt;
        if (armor == null) {
            return;
        }
        if (!armor.func_77942_o()) {
            armor.func_77982_d(new NBTTagCompound());
        }
        if (!(nbt = armor.func_77978_p()).func_74764_b(MOD_COMPOUND_KEY)) {
            nbt.func_74782_a(MOD_COMPOUND_KEY, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound mods = nbt.func_74775_l(MOD_COMPOUND_KEY);
        mods.func_82580_o(MOD_SLOT_KEY + slot);
        if (mods.func_82582_d()) {
            ArmorModHandler.clearMods(armor);
        }
    }

    public static void clearMods(ItemStack armor) {
        if (!armor.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = armor.func_77978_p();
        nbt.func_82580_o(MOD_COMPOUND_KEY);
        if (nbt.func_82582_d()) {
            armor.func_77982_d(null);
        }
    }

    public static boolean hasMods(ItemStack armor) {
        if (!armor.func_77942_o()) {
            return false;
        }
        return armor.func_77978_p().func_74764_b(MOD_COMPOUND_KEY);
    }

    public static ItemStack[] pryMods(ItemStack armor) {
        Object[] slots = new ItemStack[8];
        if (!ArmorModHandler.hasMods(armor)) {
            Arrays.fill(slots, ItemStack.field_190927_a);
            return slots;
        }
        NBTTagCompound nbt = armor.func_77978_p();
        NBTTagCompound mods = nbt.func_74775_l(MOD_COMPOUND_KEY);
        for (int i = 0; i < 8; ++i) {
            NBTTagCompound cmp = mods.func_74775_l(MOD_SLOT_KEY + i);
            ItemStack stack = new ItemStack(cmp);
            slots[i] = stack;
        }
        return slots;
    }

    public static ItemStack pryMod(ItemStack armor, int slot) {
        if (!ArmorModHandler.hasMods(armor)) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound nbt = armor.func_77978_p();
        NBTTagCompound mods = nbt.func_74775_l(MOD_COMPOUND_KEY);
        NBTTagCompound cmp = mods.func_74775_l(MOD_SLOT_KEY + slot);
        ItemStack stack = new ItemStack(cmp);
        return stack;
    }
}

