/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.EntityGrenadeTau;
import com.hbm.config.CompatibilityConfig;
import com.hbm.entity.grenade.EntityGrenadeZOMG;
import com.hbm.entity.particle.EntityChlorineFX;
import com.hbm.entity.particle.EntityCloudFX;
import com.hbm.entity.particle.EntityModFX;
import com.hbm.entity.particle.EntityOrangeFX;
import com.hbm.entity.particle.EntityPinkCloudFX;
import com.hbm.entity.projectile.EntityBullet;
import com.hbm.entity.projectile.EntityMiniNuke;
import com.hbm.entity.projectile.EntityRainbow;
import com.hbm.entity.projectile.EntityRocket;
import com.hbm.entity.projectile.EntityRubble;
import com.hbm.entity.projectile.EntitySchrab;
import com.hbm.handler.ArmorUtil;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ModDamageSource;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ArmorRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ExplosionChaos {
    private static final Random random = new Random();
    private static Random rand = new Random();

    public static void explode(World world, int x, int y, int z, int bombStartStrength) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    ExplosionChaos.destruction(world, (BlockPos)pos.func_181079_c(X, Y, Z));
                }
            }
        }
    }

    public static void explodeDecon(World world, int x, int y, int z, int bombStartStrength) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    ExplosionChaos.decontaminate(world, (BlockPos)pos.func_181079_c(X, Y, Z));
                }
            }
        }
    }

    public static void destruction(World world, BlockPos pos) {
        Block b = world.func_180495_p(pos).func_177230_c();
        if (b != Blocks.field_150357_h && b != ModBlocks.reinforced_brick && b != ModBlocks.reinforced_sand && b != ModBlocks.reinforced_glass && b != ModBlocks.reinforced_lamp_on && b != ModBlocks.reinforced_lamp_off) {
            world.func_175698_g(pos);
        }
    }

    public static void spawnExplosion(World world, int x, int y, int z, int bound) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        for (int i = 0; i < 25; ++i) {
            int randX = random.nextInt(bound);
            int randY = random.nextInt(bound);
            int randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y + randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y - randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y + randY), (double)(z - randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y + randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y - randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y + randY), (double)(z - randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y - randY), (double)(z - randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y - randY), (double)(z - randZ), 10.0f, true);
        }
    }

    public static void c(World world, int x, int y, int z, int bombStartStrength) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        float f = bombStartStrength;
        double wat = bombStartStrength * 2;
        bombStartStrength = (int)((float)bombStartStrength * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)bombStartStrength;
            if (!(d4 <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat)) continue;
            if (entity instanceof EntityPlayer && !ArmorRegistry.hasProtection((EntityLivingBase)((EntityPlayer)entity), EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.GAS_CORROSIVE)) {
                ArmorUtil.damageSuit((EntityPlayer)entity, 0, 5);
                ArmorUtil.damageSuit((EntityPlayer)entity, 1, 5);
                ArmorUtil.damageSuit((EntityPlayer)entity, 2, 5);
                ArmorUtil.damageSuit((EntityPlayer)entity, 3, 5);
            }
            if (entity instanceof EntityPlayer && ArmorUtil.checkForHazmat((EntityLivingBase)((EntityPlayer)entity)) || !(entity instanceof EntityLivingBase)) continue;
            EntityLivingBase livi = (EntityLivingBase)entity;
            if (livi.func_70644_a((Potion)HbmPotion.taint)) {
                livi.func_184589_d((Potion)HbmPotion.taint);
                livi.func_70690_d(new PotionEffect((Potion)HbmPotion.mutation, 72000, 0, false, true));
                continue;
            }
            if (ArmorRegistry.hasProtection(livi, EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.BACTERIA)) {
                ArmorUtil.damageGasMaskFilter(livi, 1);
                continue;
            }
            entity.func_70097_a(ModDamageSource.cloud, 3.0f);
        }
        bombStartStrength = (int)f;
    }

    public static void flameDeath(World world, BlockPos pos, int bound) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos);
        BlockPos.MutableBlockPos mPosUp = new BlockPos.MutableBlockPos(pos.func_177984_a());
        int r = bound;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + pos.func_177958_n();
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + pos.func_177956_o();
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + pos.func_177952_p();
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    mPos.func_181079_c(X, Y, Z);
                    mPosUp.func_181079_c(X, Y + 1, Z);
                    if (!world.func_180495_p((BlockPos)mPos).func_177230_c().isFlammable((IBlockAccess)world, (BlockPos)mPos, EnumFacing.UP) || world.func_180495_p((BlockPos)mPosUp).func_177230_c() != Blocks.field_150350_a) continue;
                    world.func_175656_a((BlockPos)mPosUp, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    public static void burn(World world, BlockPos pos, int bound) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos);
        BlockPos.MutableBlockPos mPosUp = new BlockPos.MutableBlockPos(pos.func_177984_a());
        int r = bound;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + pos.func_177958_n();
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + pos.func_177956_o();
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + pos.func_177952_p();
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    mPos.func_181079_c(X, Y, Z);
                    mPosUp.func_181079_c(X, Y + 1, Z);
                    if (world.func_180495_p((BlockPos)mPosUp).func_177230_c() != Blocks.field_150350_a && world.func_180495_p((BlockPos)mPosUp).func_177230_c() != Blocks.field_150431_aC || world.func_180495_p((BlockPos)mPos) == Blocks.field_150350_a) continue;
                    world.func_175656_a((BlockPos)mPosUp, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    public static void spawnChlorine(World world, double x, double y, double z, int count, double speed, int type) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            EntityModFX fx = null;
            fx = type == 0 ? new EntityChlorineFX(world, x, y, z, 0.0, 0.0, 0.0) : (type == 1 ? new EntityCloudFX(world, x, y, z, 0.0, 0.0, 0.0) : (type == 2 ? new EntityPinkCloudFX(world, x, y, z, 0.0, 0.0, 0.0) : new EntityOrangeFX(world, x, y, z, 0.0, 0.0, 0.0)));
            fx.field_70181_x = rand.nextGaussian() * speed;
            fx.field_70159_w = rand.nextGaussian() * speed;
            fx.field_70179_y = rand.nextGaussian() * speed;
            world.func_72838_d((Entity)fx);
        }
    }

    public static void pc(World world, int x, int y, int z, int bombStartStrength) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        float f = bombStartStrength;
        double wat = bombStartStrength * 2;
        bombStartStrength = (int)((float)bombStartStrength * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)bombStartStrength;
            if (!(d4 <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat)) continue;
            if (entity instanceof EntityPlayer && !ArmorRegistry.hasProtection((EntityLivingBase)((EntityPlayer)entity), EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.GAS_CORROSIVE)) {
                ArmorUtil.damageSuit((EntityPlayer)entity, 0, 25);
                ArmorUtil.damageSuit((EntityPlayer)entity, 1, 25);
                ArmorUtil.damageSuit((EntityPlayer)entity, 2, 25);
                ArmorUtil.damageSuit((EntityPlayer)entity, 3, 25);
            }
            if (!(entity instanceof EntityLivingBase)) continue;
            if (ArmorRegistry.hasAllProtection((EntityLivingBase)entity, EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.SAND)) {
                ArmorUtil.damageGasMaskFilter((EntityLivingBase)entity, 2);
                continue;
            }
            entity.func_70097_a(ModDamageSource.pc, 5.0f);
        }
        bombStartStrength = (int)f;
    }

    public static void poison(World world, int x, int y, int z, int bombStartStrength) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        float f = bombStartStrength;
        double wat = bombStartStrength * 2;
        bombStartStrength = (int)((float)bombStartStrength * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)bombStartStrength;
            if (!(d4 <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat) || !(entity instanceof EntityLivingBase)) continue;
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            if (ArmorRegistry.hasAllProtection(entityLiving, EntityEquipmentSlot.HEAD, ArmorRegistry.HazardClass.NERVE_AGENT)) {
                ArmorUtil.damageGasMaskFilter(entityLiving, 1);
                continue;
            }
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0));
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 400, 2));
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 20, 1));
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600, 1));
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 600, 2));
        }
        bombStartStrength = (int)f;
    }

    public static void cluster(World world, int x, int y, int z, int count, double gravity) {
        ExplosionChaos.cluster(world, x, y, z, count, gravity, 5);
    }

    public static void cluster(World world, int x, int y, int z, int count, double gravity, int size) {
        double mx = 0.0;
        double my = 0.0;
        double mz = 0.0;
        for (int i = 0; i < count; ++i) {
            mx = rand.nextGaussian() * 0.1 * (double)size;
            my = rand.nextGaussian();
            mz = rand.nextGaussian() * 0.1 * (double)size;
            EntityRocket fragment = new EntityRocket(world, x, y, z, mx, my, mz, gravity);
            fragment.explosionSize = size;
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void miniMirv(World world, double x, double y, double z) {
        double modifier = 1.25;
        double zeta = Math.sqrt(2.0) / 2.0;
        EntityMiniNuke mirv1 = new EntityMiniNuke(world);
        EntityMiniNuke mirv2 = new EntityMiniNuke(world);
        EntityMiniNuke mirv3 = new EntityMiniNuke(world);
        EntityMiniNuke mirv4 = new EntityMiniNuke(world);
        double vx1 = 1.0;
        double vy1 = rand.nextDouble() * -1.0;
        double vz1 = 0.0;
        mirv1.field_70165_t = x;
        mirv1.field_70163_u = y;
        mirv1.field_70161_v = z;
        mirv1.field_70181_x = vy1;
        mirv2.field_70165_t = x;
        mirv2.field_70163_u = y;
        mirv2.field_70161_v = z;
        mirv2.field_70181_x = vy1;
        mirv3.field_70165_t = x;
        mirv3.field_70163_u = y;
        mirv3.field_70161_v = z;
        mirv3.field_70181_x = vy1;
        mirv4.field_70165_t = x;
        mirv4.field_70163_u = y;
        mirv4.field_70161_v = z;
        mirv4.field_70181_x = vy1;
        mirv1.field_70159_w = vx1 * modifier;
        mirv1.field_70179_y = vz1 * modifier;
        world.func_72838_d((Entity)mirv1);
        mirv2.field_70159_w = -vz1 * modifier;
        mirv2.field_70179_y = vx1 * modifier;
        world.func_72838_d((Entity)mirv2);
        mirv3.field_70159_w = -vx1 * modifier;
        mirv3.field_70179_y = -vz1 * modifier;
        world.func_72838_d((Entity)mirv3);
        mirv4.field_70159_w = vz1 * modifier;
        mirv4.field_70179_y = -vx1 * modifier;
        world.func_72838_d((Entity)mirv4);
        EntityMiniNuke mirv5 = new EntityMiniNuke(world);
        EntityMiniNuke mirv6 = new EntityMiniNuke(world);
        EntityMiniNuke mirv7 = new EntityMiniNuke(world);
        EntityMiniNuke mirv8 = new EntityMiniNuke(world);
        double vx2 = zeta;
        double vy2 = vy1;
        double vz2 = zeta;
        mirv5.field_70165_t = x;
        mirv5.field_70163_u = y;
        mirv5.field_70161_v = z;
        mirv5.field_70181_x = vy2;
        mirv6.field_70165_t = x;
        mirv6.field_70163_u = y;
        mirv6.field_70161_v = z;
        mirv6.field_70181_x = vy2;
        mirv7.field_70165_t = x;
        mirv7.field_70163_u = y;
        mirv7.field_70161_v = z;
        mirv7.field_70181_x = vy2;
        mirv8.field_70165_t = x;
        mirv8.field_70163_u = y;
        mirv8.field_70161_v = z;
        mirv8.field_70181_x = vy2;
        mirv5.field_70159_w = vx2 * modifier;
        mirv5.field_70179_y = vz2 * modifier;
        world.func_72838_d((Entity)mirv5);
        mirv6.field_70159_w = -vz2 * modifier;
        mirv6.field_70179_y = vx2 * modifier;
        world.func_72838_d((Entity)mirv6);
        mirv7.field_70159_w = -vx2 * modifier;
        mirv7.field_70179_y = -vz2 * modifier;
        world.func_72838_d((Entity)mirv7);
        mirv8.field_70159_w = vz2 * modifier;
        mirv8.field_70179_y = -vx2 * modifier;
        world.func_72838_d((Entity)mirv8);
    }

    public static void explodeZOMG(World world, int x, int y, int z, int bombStartStrength) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    pos.func_181079_c(X, Y, Z);
                    if (world.func_180495_p((BlockPos)pos).func_177230_c() == Blocks.field_150357_h && Y <= 0) continue;
                    world.func_175698_g((BlockPos)pos);
                }
            }
        }
    }

    public static void frag(World world, int x, int y, int z, int count, boolean flame, Entity shooter) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < count; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntityTippedArrow fragment = new EntityTippedArrow(world, (double)x, (double)y, (double)z);
            fragment.field_70159_w = d1;
            fragment.field_70181_x = d2;
            fragment.field_70179_y = d3;
            fragment.field_70250_c = shooter;
            fragment.func_70243_d(true);
            if (flame) {
                fragment.func_70015_d(1000);
            }
            fragment.func_70239_b(2.5);
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void schrab(World world, int x, int y, int z, int count, int gravity) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < count; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntitySchrab fragment = new EntitySchrab(world, x, y, z, d1, d2, d3, 0.0125);
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void pulse(World world, int x, int y, int z, int bombStartStrength) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    BlockPos blockPos = new BlockPos(X, Y, Z);
                    if (!(world.func_180495_p(blockPos).func_177230_c().func_149638_a(null) <= 70.0f)) continue;
                    ExplosionChaos.pDestruction(world, X, Y, Z);
                }
            }
        }
    }

    public static void pDestruction(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), state);
        world.func_72838_d((Entity)entityfallingblock);
    }

    public static void plasma(World world, int x, int y, int z, int radius) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = radius;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 + world.field_73012_v.nextInt(r22 / 2)) continue;
                    pos.func_181079_c(X, Y, Z);
                    Block block = world.func_180495_p((BlockPos)pos).func_177230_c();
                    if (block.func_149638_a(null) > 0.1f || block == Blocks.field_150357_h || world.func_180495_p((BlockPos)pos).func_177230_c() == ModBlocks.statue_elb || world.func_180495_p((BlockPos)pos).func_177230_c() == ModBlocks.statue_elb_g || world.func_180495_p((BlockPos)pos).func_177230_c() == ModBlocks.statue_elb_w || world.func_180495_p((BlockPos)pos).func_177230_c() == ModBlocks.statue_elb_f) continue;
                    world.func_175656_a((BlockPos)pos, ModBlocks.plasma.func_176223_P());
                }
            }
        }
    }

    public static void tauMeSinPi(World world, double x, double y, double z, int count, Entity shooter, EntityGrenadeTau tau) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (shooter != null && shooter instanceof EntityPlayer) {
            for (int i = 0; i < count; ++i) {
                EntityBullet fragment;
                d1 = rand.nextDouble();
                d2 = rand.nextDouble();
                d3 = rand.nextDouble();
                if (rand.nextInt(2) == 0) {
                    d1 *= -1.0;
                }
                if (rand.nextInt(2) == 0) {
                    d2 *= -1.0;
                }
                if (rand.nextInt(2) == 0) {
                    d3 *= -1.0;
                }
                if (rand.nextInt(5) == 0) {
                    fragment = new EntityBullet(world, (EntityLivingBase)((EntityPlayer)shooter), 3.0f, 35, 45, false, "tauDay", tau);
                    fragment.setDamage(rand.nextInt(301) + 100);
                } else {
                    fragment = new EntityBullet(world, (EntityLivingBase)((EntityPlayer)shooter), 3.0f, 35, 45, false, "eyyOk", tau);
                    fragment.setDamage(rand.nextInt(11) + 35);
                }
                fragment.field_70159_w = d1 * 5.0;
                fragment.field_70181_x = d2 * 5.0;
                fragment.field_70179_y = d3 * 5.0;
                fragment.shootingEntity = shooter;
                fragment.setIsCritical(true);
                world.func_72838_d((Entity)fragment);
            }
        }
    }

    public static void zomg(World world, double x, double y, double z, int count, Entity shooter, EntityGrenadeZOMG zomg) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < count; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d2 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntityRainbow entityZomg = new EntityRainbow(world, (EntityLivingBase)((EntityPlayer)shooter), 1.0f, 10000, 100000, zomg);
            entityZomg.field_70159_w = d1;
            entityZomg.field_70181_x = d2;
            entityZomg.field_70179_y = d3;
            entityZomg.shootingEntity = shooter;
            world.func_72838_d((Entity)entityZomg);
            world.func_184148_a(null, zomg.field_70165_t, zomg.field_70163_u, zomg.field_70161_v, HBMSoundHandler.zomgShoot, SoundCategory.AMBIENT, 10.0f, 0.8f + rand.nextFloat() * 0.4f);
        }
    }

    public static void spawnVolley(World world, double x, double y, double z, int count, double speed) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            EntityOrangeFX fx = new EntityOrangeFX(world, x, y, z, 0.0, 0.0, 0.0);
            fx.field_70159_w = rand.nextGaussian() * speed;
            fx.field_70179_y = rand.nextGaussian() * speed;
            fx.field_70181_x = rand.nextDouble() * speed * 7.5;
            world.func_72838_d((Entity)fx);
        }
    }

    public static void floater(World world, BlockPos pos, int radi, int height) {
        ExplosionChaos.floater(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), radi, height);
    }

    public static void floater(World world, int x, int y, int z, int radi, int height) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = radi;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    pos.func_181079_c(X, Y, Z);
                    IBlockState save = world.func_180495_p((BlockPos)pos);
                    world.func_175656_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P());
                    if (save.func_177230_c() == Blocks.field_150350_a) continue;
                    world.func_175656_a((BlockPos)pos.func_181079_c(X, Y + height, Z), save);
                }
            }
        }
    }

    public static void move(World world, BlockPos pos, int radius, int a, int b, int c) {
        ExplosionChaos.move(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), radius, a, b, c);
    }

    public static void move(World world, int x, int y, int z, int radius, int a, int b, int c) {
        float f = radius;
        double wat = radius;
        int rand = 0;
        radius = (int)((float)radius * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)radius;
            if (!(d4 <= 1.0)) continue;
            double d5 = entity.field_70165_t - (double)x;
            double d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y;
            double d7 = entity.field_70161_v - (double)z;
            if (entity instanceof EntityLiving && !(entity instanceof EntitySheep)) {
                rand = random.nextInt(2);
                if (rand == 0) {
                    ((EntityLiving)entity).func_96094_a("Dinnerbone");
                } else {
                    ((EntityLiving)entity).func_96094_a("Grumm");
                }
            }
            if (entity instanceof EntitySheep) {
                ((EntityLiving)entity).func_96094_a("jeb_");
            }
            if (!((d9 = (double)MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7))) < wat)) continue;
            entity.func_70107_b(entity.field_70165_t += (double)a, entity.field_70163_u += (double)b, entity.field_70161_v += (double)c);
        }
        radius = (int)f;
    }

    public static void levelDown(World world, int x, int y, int z, int radius) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (!world.field_72995_K) {
            for (int i = x - radius; i <= x + radius; ++i) {
                for (int j = z - radius; j <= z + radius; ++j) {
                    IBlockState b = world.func_180495_p((BlockPos)pos.func_181079_c(i, y, j));
                    float k = b.func_185887_b(world, (BlockPos)pos.func_181079_c(i, y, j));
                    if (!(k < 6000.0f) || !(k > 0.0f) || b.func_177230_c() == Blocks.field_150350_a) continue;
                    EntityRubble rubble = new EntityRubble(world);
                    rubble.field_70165_t = (float)i + 0.5f;
                    rubble.field_70163_u = y;
                    rubble.field_70161_v = (float)j + 0.5f;
                    rubble.field_70181_x = 0.4f;
                    rubble.setMetaBasedOnBlock(b.func_177230_c(), b.func_177230_c().func_176201_c(b));
                    world.func_72838_d((Entity)rubble);
                    world.func_175656_a((BlockPos)pos.func_181079_c(i, y, j), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public static void decontaminate(World world, BlockPos pos) {
        Random random = new Random();
        IBlockState b = world.func_180495_p(pos);
        Block bblock = b.func_177230_c();
        if (bblock == ModBlocks.waste_earth && random.nextInt(3) != 0) {
            world.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
        } else if (bblock == ModBlocks.waste_dirt && random.nextInt(3) != 0) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        } else if (bblock == ModBlocks.waste_sand && random.nextInt(3) != 0) {
            world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
        } else if (bblock == ModBlocks.waste_sand_red && random.nextInt(3) != 0) {
            world.func_175656_a(pos, Blocks.field_150354_m.func_176203_a(1));
        } else if (bblock == Blocks.field_150322_A && random.nextInt(3) != 0) {
            world.func_175656_a(pos, ModBlocks.waste_sandstone.func_176223_P());
        } else if ((bblock == Blocks.field_150405_ch || bblock == Blocks.field_150406_ce) && random.nextInt(3) != 0) {
            world.func_175656_a(pos, ModBlocks.waste_sandstone_red.func_176223_P());
        } else if (bblock == Blocks.field_180395_cM && random.nextInt(3) != 0) {
            world.func_175656_a(pos, ModBlocks.waste_sandstone_red.func_176223_P());
        } else if (bblock == ModBlocks.waste_grass_tall && random.nextInt(3) != 0) {
            world.func_175656_a(pos, Blocks.field_150329_H.func_176223_P());
        } else if (bblock == ModBlocks.waste_gravel && random.nextInt(3) != 0) {
            world.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
        } else if (bblock == ModBlocks.waste_mycelium && random.nextInt(5) == 0) {
            world.func_175656_a(pos, Blocks.field_150391_bh.func_176223_P());
        } else if (bblock == ModBlocks.waste_leaves && random.nextInt(5) != 0) {
            world.func_175656_a(pos, Blocks.field_150362_t.func_176223_P());
        } else if (bblock == ModBlocks.waste_trinitite && random.nextInt(3) == 0) {
            world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
        } else if (bblock == ModBlocks.waste_trinitite_red && random.nextInt(3) == 0) {
            world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND));
        } else if (bblock == ModBlocks.waste_log && random.nextInt(3) != 0) {
            world.func_175656_a(pos, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)((EnumFacing.Axis)world.func_180495_p(pos).func_177229_b((IProperty)BlockLog.field_176298_M)))));
        } else if (bblock == ModBlocks.waste_planks && random.nextInt(3) != 0) {
            world.func_175656_a(pos, Blocks.field_150344_f.func_176223_P());
        } else if (bblock == ModBlocks.block_trinitite && random.nextInt(10) == 0) {
            world.func_175656_a(pos, ModBlocks.block_lead.func_176223_P());
        } else if (bblock == ModBlocks.block_waste && random.nextInt(10) == 0) {
            world.func_175656_a(pos, ModBlocks.block_lead.func_176223_P());
        } else if (bblock == ModBlocks.sellafield_core && random.nextInt(10) == 0) {
            world.func_175656_a(pos, ModBlocks.sellafield_4.func_176203_a(world.field_73012_v.nextInt(4)));
        } else if (bblock == ModBlocks.sellafield_4 && random.nextInt(5) == 0) {
            world.func_175656_a(pos, ModBlocks.sellafield_3.func_176203_a(world.field_73012_v.nextInt(4)));
        } else if (bblock == ModBlocks.sellafield_3 && random.nextInt(5) == 0) {
            world.func_175656_a(pos, ModBlocks.sellafield_2.func_176203_a(world.field_73012_v.nextInt(4)));
        } else if (bblock == ModBlocks.sellafield_2 && random.nextInt(5) == 0) {
            world.func_175656_a(pos, ModBlocks.sellafield_1.func_176203_a(world.field_73012_v.nextInt(4)));
        } else if (bblock == ModBlocks.sellafield_1 && random.nextInt(5) == 0) {
            world.func_175656_a(pos, ModBlocks.sellafield_0.func_176203_a(world.field_73012_v.nextInt(4)));
        } else if (bblock == ModBlocks.sellafield_0 && random.nextInt(5) == 0) {
            world.func_175656_a(pos, ModBlocks.sellafield_slaked.func_176203_a(world.field_73012_v.nextInt(4)));
        } else if (bblock == ModBlocks.sellafield_slaked && random.nextInt(5) == 0) {
            world.func_175656_a(pos, Blocks.field_150348_b.func_176223_P());
        }
    }

    public static void hardenVirus(World world, int x, int y, int z, int bombStartStrength) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || world.func_180495_p((BlockPos)pos.func_181079_c(X, Y, Z)).func_177230_c() != ModBlocks.crystal_virus) continue;
                    world.func_175656_a((BlockPos)pos.func_181079_c(X, Y, Z), ModBlocks.crystal_hardened.func_176223_P());
                }
            }
        }
    }

    public static void spreadVirus(World world, int x, int y, int z, int bombStartStrength) {
        if (!CompatibilityConfig.isWarDim(world)) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || rand.nextInt(15) != 0 || world.func_180495_p((BlockPos)pos.func_181079_c(X, Y, Z)).func_177230_c() == Blocks.field_150350_a) continue;
                    world.func_175656_a((BlockPos)pos.func_181079_c(X, Y, Z), ModBlocks.cheater_virus_seed.func_176223_P());
                }
            }
        }
    }
}

