/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ExplosionBalefire {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public int radius2;
    public World worldObj;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;

    public void saveToNbt(NBTTagCompound nbt, String name) {
        nbt.func_74768_a(name + "posX", this.posX);
        nbt.func_74768_a(name + "posY", this.posY);
        nbt.func_74768_a(name + "posZ", this.posZ);
        nbt.func_74768_a(name + "lastposX", this.lastposX);
        nbt.func_74768_a(name + "lastposZ", this.lastposZ);
        nbt.func_74768_a(name + "radius", this.radius);
        nbt.func_74768_a(name + "radius2", this.radius2);
        nbt.func_74768_a(name + "n", this.n);
        nbt.func_74768_a(name + "nlimit", this.nlimit);
        nbt.func_74768_a(name + "shell", this.shell);
        nbt.func_74768_a(name + "leg", this.leg);
        nbt.func_74768_a(name + "element", this.element);
    }

    public void readFromNbt(NBTTagCompound nbt, String name) {
        this.posX = nbt.func_74762_e(name + "posX");
        this.posY = nbt.func_74762_e(name + "posY");
        this.posZ = nbt.func_74762_e(name + "posZ");
        this.lastposX = nbt.func_74762_e(name + "lastposX");
        this.lastposZ = nbt.func_74762_e(name + "lastposZ");
        this.radius = nbt.func_74762_e(name + "radius");
        this.radius2 = nbt.func_74762_e(name + "radius2");
        this.n = nbt.func_74762_e(name + "n");
        this.nlimit = nbt.func_74762_e(name + "nlimit");
        this.shell = nbt.func_74762_e(name + "shell");
        this.leg = nbt.func_74762_e(name + "leg");
        this.element = nbt.func_74762_e(name + "element");
    }

    public ExplosionBalefire(int x, int y, int z, World world, int rad) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.worldObj = world;
        this.radius = rad;
        this.radius2 = this.radius * this.radius;
        this.nlimit = this.radius2 * 4;
    }

    public boolean update() {
        this.breakColumn(this.lastposX, this.lastposZ);
        this.shell = (int)Math.floor((Math.sqrt(this.n) + 1.0) / 2.0);
        if (this.shell == 0) {
            this.shell = 1;
        }
        int shell2 = this.shell * 2;
        this.leg = (int)Math.floor((this.n - (shell2 - 1) * (shell2 - 1)) / shell2);
        this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
        int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
        this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
        ++this.n;
        return this.n > this.nlimit;
    }

    private void breakColumn(int x, int z) {
        int dist = (int)((double)this.radius - Math.sqrt(x * x + z * z));
        if (dist > 0) {
            Block b;
            int y;
            int pX = this.posX + x;
            int pZ = this.posZ + z;
            int maxdepth = (int)(10.0 + (double)this.radius * 0.25);
            int voidDepth = (int)((double)(maxdepth * dist / this.radius) + Math.sin((double)dist * 0.15 + 2.0) * 2.0);
            int depth = Math.max(y - voidDepth, 0);
            for (y = this.worldObj.func_189649_b(pX, pZ); y > depth; --y) {
                b = this.worldObj.func_180495_p(new BlockPos(pX, y, pZ)).func_177230_c();
                if (b == ModBlocks.block_schrabidium_cluster) {
                    if (this.worldObj.field_73012_v.nextInt(10) == 0) {
                        this.worldObj.func_175656_a(new BlockPos(pX, y + 1, pZ), ModBlocks.balefire.func_176223_P());
                        this.worldObj.func_180501_a(new BlockPos(pX, y, pZ), ModBlocks.block_euphemium_cluster.func_176203_a(b.func_176201_c(this.worldObj.func_180495_p(new BlockPos(pX, y, pZ)))), 3);
                    }
                    return;
                }
                if (b == ModBlocks.cmb_brick_reinforced) {
                    if (this.worldObj.field_73012_v.nextInt(10) == 0) {
                        this.worldObj.func_175656_a(new BlockPos(pX, y + 1, pZ), ModBlocks.balefire.func_176223_P());
                    }
                    return;
                }
                this.worldObj.func_175698_g(new BlockPos(pX, y, pZ));
            }
            if (this.worldObj.field_73012_v.nextInt(10) == 0) {
                this.worldObj.func_175656_a(new BlockPos(pX, depth + 1, pZ), ModBlocks.balefire.func_176223_P());
                b = this.worldObj.func_180495_p(new BlockPos(pX, y, pZ)).func_177230_c();
                if (b == ModBlocks.block_schrabidium_cluster) {
                    this.worldObj.func_180501_a(new BlockPos(pX, y, pZ), ModBlocks.block_euphemium_cluster.func_176203_a(b.func_176201_c(this.worldObj.func_180495_p(new BlockPos(pX, y, pZ)))), 3);
                }
            }
            int startDepth = 6 * dist / this.radius;
            block10: for (int i = 0; i <= startDepth; ++i) {
                if (this.worldObj.func_180495_p(new BlockPos(pX, depth - i, pZ)).func_177230_c() != Blocks.field_150348_b) continue;
                switch (startDepth - i) {
                    case 6: {
                        this.worldObj.func_175656_a(new BlockPos(pX, depth - i, pZ), ModBlocks.baleonitite_core.func_176223_P());
                        continue block10;
                    }
                    case 5: {
                        this.worldObj.func_175656_a(new BlockPos(pX, depth - i, pZ), ModBlocks.baleonitite_4.func_176223_P());
                        continue block10;
                    }
                    case 4: {
                        this.worldObj.func_175656_a(new BlockPos(pX, depth - i, pZ), ModBlocks.baleonitite_3.func_176223_P());
                        continue block10;
                    }
                    case 3: {
                        this.worldObj.func_175656_a(new BlockPos(pX, depth - i, pZ), ModBlocks.baleonitite_2.func_176223_P());
                        continue block10;
                    }
                    case 2: {
                        this.worldObj.func_175656_a(new BlockPos(pX, depth - i, pZ), ModBlocks.baleonitite_1.func_176223_P());
                        continue block10;
                    }
                    case 1: {
                        this.worldObj.func_175656_a(new BlockPos(pX, depth - i, pZ), ModBlocks.baleonitite_0.func_176223_P());
                        continue block10;
                    }
                    case 0: {
                        this.worldObj.func_175656_a(new BlockPos(pX, depth - i, pZ), ModBlocks.baleonitite_slaked.func_176223_P());
                    }
                }
            }
        }
    }
}

