/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import api.hbm.entity.IRadarDetectable;
import com.hbm.config.WeaponConfig;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.items.ModItems;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.LoopedEntitySoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityMissileAntiBallistic
extends EntityMissileBaseAdvanced {
    public static final double particleSpeed = 1.75;
    private static final double steps = 5.0;

    public EntityMissileAntiBallistic(World p_i1582_1_) {
        super(p_i1582_1_);
        this.field_70181_x = 0.5;
        this.func_70105_a(1.0f, 8.0f);
        this.velocity = 0.0;
    }

    @Override
    public void func_70071_h_() {
        double oldPosY = this.field_70163_u;
        if (this.field_70173_aa < 10) {
            ExplosionLarge.spawnParticlesRadial(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15);
            return;
        }
        if (this.field_70173_aa < 60) {
            this.field_70181_x = 0.5;
            this.func_70012_b(this.field_70165_t + this.field_70159_w * this.velocity, this.field_70163_u + this.field_70181_x * this.velocity, this.field_70161_v + this.field_70179_y * this.velocity, (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI), (float)(Math.atan2(this.field_70181_x, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 180.0 / Math.PI) - 90.0f);
            if (this.field_70170_p.field_72995_K) {
                MainRegistry.proxy.spawnParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v, "exHydrogen", new float[]{(float)(this.field_70159_w * -1.75), (float)(this.field_70181_x * -1.75), (float)(this.field_70179_y * -1.75)});
            }
            return;
        }
        this.func_184212_Q().func_187227_b(HEALTH, (Object)this.health);
        if (this.velocity < 20.0) {
            this.velocity += 0.05;
        }
        int i = 0;
        while ((double)i < 5.0) {
            double[] targetVec = this.targetMissile();
            if (targetVec != null) {
                this.field_70159_w = targetVec[0] * this.velocity;
                this.field_70181_x = targetVec[1] * this.velocity;
                this.field_70179_y = targetVec[2] * this.velocity;
            }
            this.func_70012_b(this.field_70165_t + this.field_70159_w * this.velocity, this.field_70163_u + this.field_70181_x * this.velocity, this.field_70161_v + this.field_70179_y * this.velocity, (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI), (float)(Math.atan2(this.field_70181_x, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 180.0 / Math.PI) - 90.0f);
            if (this.field_70170_p.field_72995_K) {
                MainRegistry.proxy.spawnParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v, "exDark", new float[]{(float)(this.field_70159_w * -1.75), (float)(this.field_70181_x * -1.75), (float)(this.field_70179_y * -1.75)});
            }
            this.explodeIfNearTarget();
            ++i;
        }
        Block b = this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)).func_177230_c();
        if (b != Blocks.field_150350_a && b != Blocks.field_150355_j && b != Blocks.field_150358_i || this.field_70163_u < 1.0 || this.field_70163_u > 7000.0) {
            if (this.field_70163_u < 1.0) {
                this.func_70012_b((int)this.field_70165_t, this.field_70170_p.func_189649_b((int)this.field_70165_t, (int)this.field_70161_v), (int)this.field_70161_v, 0.0f, 0.0f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.onImpact();
            }
            this.func_70106_y();
            return;
        }
        PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedEntitySoundPacket(this.func_145782_y()));
        if ((int)(this.field_70165_t / 16.0) != this.chunkX || (int)(this.field_70161_v / 16.0) != this.chunkZ) {
            this.chunkX = (int)(this.field_70165_t / 16.0);
            this.chunkZ = (int)(this.field_70161_v / 16.0);
            this.loadNeighboringChunks(this.chunkX, this.chunkZ);
        }
        this.field_70167_r = oldPosY;
    }

    private double[] targetMissile() {
        List listOfMissiles = this.field_70170_p.func_72839_b(null, new AxisAlignedBB(this.field_70165_t - (double)WeaponConfig.radarRange, 0.0, this.field_70161_v - (double)WeaponConfig.radarRange, this.field_70165_t + (double)WeaponConfig.radarRange, 5000.0, this.field_70161_v + (double)WeaponConfig.radarRange));
        Entity target = null;
        double closest = WeaponConfig.radarRange * 2;
        for (Entity e : listOfMissiles) {
            double dis;
            if (e instanceof EntityMissileAntiBallistic || !(e instanceof EntityMissileBaseAdvanced) && !(e instanceof EntityMissileCustom) || !((dis = Math.sqrt(Math.pow(e.field_70165_t - this.field_70165_t, 2.0) + Math.pow(e.field_70163_u - this.field_70163_u, 2.0) + Math.pow(e.field_70161_v - this.field_70161_v, 2.0))) < closest)) continue;
            closest = dis;
            target = e;
        }
        if (target != null) {
            Vec3 vec = Vec3.createVectorHelper(target.field_70165_t - this.field_70165_t, target.field_70163_u - this.field_70163_u, target.field_70161_v - this.field_70161_v);
            vec = vec.normalize();
            return new double[]{vec.xCoord / 5.0, vec.yCoord / 5.0, vec.zCoord / 5.0};
        }
        return null;
    }

    private void explodeIfNearTarget() {
        List listOfMissilesInExplosionRange = this.field_70170_p.func_72839_b(null, new AxisAlignedBB(this.field_70165_t - 7.5, this.field_70163_u - 7.5, this.field_70161_v - 7.5, this.field_70165_t + 7.5, this.field_70163_u + 7.5, this.field_70161_v + 7.5));
        boolean hasHits = false;
        for (Entity e : listOfMissilesInExplosionRange) {
            if (e instanceof EntityMissileAntiBallistic || !(e instanceof EntityMissileBaseAdvanced) && !(e instanceof EntityMissileCustom)) continue;
            e.func_70097_a(ModDamageSource.blast, 40.0f);
            hasHits = true;
        }
        if (hasHits) {
            ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15.0f, true, false, true);
            this.func_70106_y();
            return;
        }
    }

    @Override
    public IRadarDetectable.RadarTargetType getTargetType() {
        return IRadarDetectable.RadarTargetType.MISSILE_AB;
    }

    @Override
    public List<ItemStack> getDebris() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(ModItems.plate_titanium, 4));
        list.add(new ItemStack(ModItems.thruster_small, 1));
        list.add(new ItemStack(ModItems.circuit_targeting_tier1, 1));
        return list;
    }

    @Override
    public ItemStack getDebrisRareDrop() {
        return new ItemStack(ModItems.circuit_targeting_tier3);
    }

    @Override
    public void onImpact() {
        ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10.0f, true, true, true);
    }
}

