/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.config.BombConfig;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.effect.EntityFalloutRain;
import com.hbm.entity.effect.EntityFalloutUnderGround;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.entity.mob.EntityGlowingOne;
import com.hbm.explosion.ExplosionNukeRayBatched;
import com.hbm.main.MainRegistry;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeChunkManager;
import org.apache.logging.log4j.Level;

public class EntityNukeExplosionMK5
extends Entity
implements IChunkLoader {
    public int strength;
    public int radius;
    public boolean mute = false;
    public boolean spawnFire = false;
    public boolean fallout = true;
    private boolean floodPlease = false;
    private int falloutAdd = 0;
    private ForgeChunkManager.Ticket loaderTicket;
    ExplosionNukeRayBatched explosion;
    EntityFalloutUnderGround falloutBall;
    EntityFalloutRain falloutRain;
    private int nukeTickNumber = 0;
    List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();
    private ChunkPos mainChunk;

    public EntityNukeExplosionMK5(World world) {
        super(world);
    }

    public EntityNukeExplosionMK5(World world, int strength, int speed, int radius) {
        super(world);
        this.strength = strength;
        this.radius = radius;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.strength == 0 || !CompatibilityConfig.isWarDim(this.field_70170_p)) {
            this.clearLoadedChunks();
            this.unloadMainChunk();
            this.func_70106_y();
            return;
        }
        this.loadMainChunk();
        float blast = 0.0f;
        float fire = 0.0f;
        float rads = 0.0f;
        if (this.fallout && this.falloutRain == null) {
            rads = (float)(Math.pow(this.radius, 4.0) * (double)((float)Math.pow(0.5, (double)this.field_70173_aa * 0.125)) + (double)this.strength);
            if (this.field_70173_aa == 42) {
                EntityGlowingOne.convertInRadiusToGlow(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.radius * 1.5);
            }
        }
        if (this.field_70173_aa < 2400 && this.field_70173_aa % 10 == 0) {
            fire = (this.fallout ? 10.0f : 2.0f) * (float)Math.pow(this.radius, 3.0) * (float)Math.pow(0.5, (double)this.field_70173_aa * 0.025);
            blast = (float)Math.pow(this.radius, 3.0) * 0.2f;
            ContaminationUtil.radiate(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, Math.min(1000, this.radius * 2), rads, 0.0f, fire, blast, (float)this.field_70173_aa * 1.5f);
        }
        if (!this.mute) {
            if (this.radius > 30) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.AMBIENT, (float)this.radius * 0.05f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
                if (this.field_70146_Z.nextInt(5) == 0) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, (float)this.radius * 0.05f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
                }
            } else {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, Math.max(2.0f, (float)this.radius * 0.1f), 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            }
        }
        if (this.explosion == null) {
            this.explosion = new ExplosionNukeRayBatched(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.strength, this.radius);
        }
        if (!this.explosion.isAusf3Complete) {
            this.explosion.collectTip(BombConfig.mk5);
        } else if (this.explosion.perChunk.size() > 0) {
            this.explosion.processChunk(BombConfig.mk5);
        } else {
            if (this.fallout) {
                EntityFalloutUnderGround falloutBall = new EntityFalloutUnderGround(this.field_70170_p);
                falloutBall.field_70165_t = this.field_70165_t;
                falloutBall.field_70163_u = this.field_70163_u;
                falloutBall.field_70161_v = this.field_70161_v;
                falloutBall.setScale((int)((float)this.radius * ((float)BombConfig.falloutRange / 100.0f) + (float)this.falloutAdd));
                falloutBall.falloutRainDoFallout = this.fallout && !this.explosion.isContained;
                falloutBall.falloutRainDoFlood = this.floodPlease;
                falloutBall.falloutRainFire = this.spawnFire;
                falloutBall.falloutRainRadius1 = (int)(((float)this.radius * 2.5f + (float)this.falloutAdd) * (float)BombConfig.falloutRange * 0.01f);
                falloutBall.falloutRainRadius2 = this.radius + 4;
                this.field_70170_p.func_72838_d((Entity)falloutBall);
            } else {
                EntityFalloutRain falloutRain = new EntityFalloutRain(this.field_70170_p);
                falloutRain.doFallout = false;
                falloutRain.doFlood = this.floodPlease;
                falloutRain.field_70165_t = this.field_70165_t;
                falloutRain.field_70163_u = this.field_70163_u;
                falloutRain.field_70161_v = this.field_70161_v;
                if (this.spawnFire) {
                    falloutRain.spawnFire = true;
                }
                falloutRain.setScale((int)(((float)this.radius * 2.5f + (float)this.falloutAdd) * (float)BombConfig.falloutRange * 0.01f), this.radius + 4);
                this.field_70170_p.func_72838_d((Entity)falloutRain);
            }
            this.clearLoadedChunks();
            this.unloadMainChunk();
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)new ChunkPos(this.field_70176_ah, this.field_70164_aj));
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ - 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX + 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + 1));
            this.loadedChunks.add(new ChunkPos(newChunkX - 1, newChunkZ));
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ - 1));
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    public void clearLoadedChunks() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null && this.loadedChunks != null) {
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    public void loadMainChunk() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null && this.mainChunk == null) {
            this.mainChunk = new ChunkPos((int)Math.floor(this.field_70165_t / 16.0), (int)Math.floor(this.field_70161_v / 16.0));
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)this.mainChunk);
        }
    }

    public void unloadMainChunk() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null && this.mainChunk != null) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)this.mainChunk);
        }
    }

    private static boolean isWet(World world, BlockPos pos) {
        Biome b = world.func_180494_b(pos);
        return b.func_150561_m() == Biome.TempCategory.OCEAN || b.func_76736_e() || b == Biomes.field_76787_r || b == Biomes.field_76771_b || b == Biomes.field_76781_i || b == Biomes.field_150575_M || b == Biomes.field_76776_l || b == Biomes.field_76777_m || b == Biomes.field_150576_N || b == Biomes.field_76780_h;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.radius = nbt.func_74762_e("radius");
        this.strength = nbt.func_74762_e("strength");
        this.falloutAdd = nbt.func_74762_e("falloutAdd");
        this.fallout = nbt.func_74767_n("fallout");
        this.floodPlease = nbt.func_74767_n("floodPlease");
        this.spawnFire = nbt.func_74767_n("spawnFire");
        this.mute = nbt.func_74767_n("mute");
        if (this.explosion == null) {
            this.explosion = new ExplosionNukeRayBatched(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.strength, this.radius);
        }
        this.explosion.readEntityFromNBT(nbt);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("radius", this.radius);
        nbt.func_74768_a("strength", this.strength);
        nbt.func_74768_a("falloutAdd", this.falloutAdd);
        nbt.func_74757_a("fallout", this.fallout);
        nbt.func_74757_a("floodPlease", this.floodPlease);
        nbt.func_74757_a("spawnFire", this.spawnFire);
        nbt.func_74757_a("mute", this.mute);
        if (this.explosion != null) {
            this.explosion.writeEntityToNBT(nbt);
        }
    }

    public static EntityNukeExplosionMK5 statFac(World world, int r, double x, double y, double z) {
        if (GeneralConfig.enableExtendedLogging && !world.field_72995_K) {
            MainRegistry.logger.log(Level.INFO, "[NUKE] Initialized explosion at " + x + " / " + y + " / " + z + " with radius " + r + "!");
        }
        if (r == 0) {
            r = 25;
        }
        EntityNukeExplosionMK5 mk5 = new EntityNukeExplosionMK5(world);
        mk5.strength = 2 * r;
        mk5.radius = r;
        mk5.func_70107_b(x, y, z);
        mk5.floodPlease = EntityNukeExplosionMK5.isWet(world, new BlockPos(x, y, z));
        if (BombConfig.disableNuclear) {
            mk5.fallout = false;
        }
        return mk5;
    }

    public static EntityNukeExplosionMK5 statFacFire(World world, int r, double x, double y, double z) {
        EntityNukeExplosionMK5 mk5 = EntityNukeExplosionMK5.statFac(world, r, x, y, z);
        mk5.spawnFire = true;
        return mk5;
    }

    public static EntityNukeExplosionMK5 statFacNoRad(World world, int r, double x, double y, double z) {
        EntityNukeExplosionMK5 mk5 = EntityNukeExplosionMK5.statFac(world, r, x, y, z);
        mk5.fallout = false;
        return mk5;
    }

    public static EntityNukeExplosionMK5 statFacNoRadFire(World world, int r, double x, double y, double z) {
        EntityNukeExplosionMK5 mk5 = EntityNukeExplosionMK5.statFac(world, r, x, y, z);
        mk5.fallout = false;
        mk5.spawnFire = true;
        return mk5;
    }

    public EntityNukeExplosionMK5 moreFallout(int fallout) {
        this.falloutAdd = fallout;
        return this;
    }

    public EntityNukeExplosionMK5 mute() {
        this.mute = true;
        return this;
    }
}

