/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.core;

import com.hbm.main.ModEventHandlerClient;
import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class GlStateManagerClassTransformer
implements IClassTransformer {
    private static final String[] classesBeingTransformed = new String[]{"net.minecraft.client.renderer.GlStateManager"};

    public byte[] transform(String name, String transformedName, byte[] classBeingTransformed) {
        boolean isObfuscated = !name.equals(transformedName);
        int index = Arrays.asList(classesBeingTransformed).indexOf(transformedName);
        return index != -1 ? GlStateManagerClassTransformer.transform(index, classBeingTransformed, isObfuscated) : classBeingTransformed;
    }

    private static byte[] transform(int index, byte[] classBeingTransformed, boolean isObfuscated) {
        System.out.println("Transforming: " + classesBeingTransformed[index]);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classBeingTransformed);
            classReader.accept((ClassVisitor)classNode, 0);
            switch (index) {
                case 0: {
                    GlStateManagerClassTransformer.transformGlStateManager(classNode, isObfuscated);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return classBeingTransformed;
        }
    }

    private static void transformGlStateManager(ClassNode profilerClass, boolean isObfuscated) {
        for (MethodNode method : profilerClass.methods) {
            if (method.name.equals("disableLighting") || method.name.equals("func_179140_f")) {
                method.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(ModEventHandlerClient.class), "onLightingDisable", "()V", false));
            }
            if (!method.name.equals("enableLighting") && !method.name.equals("func_179145_e")) continue;
            method.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(ModEventHandlerClient.class), "onLightingEnable", "()V", false));
        }
    }
}

