/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network.energy;

import api.hbm.block.IToolable;
import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IEnergyConnectorBlock;
import api.hbm.energy.IEnergyUser;
import api.hbm.energy.Nodespace;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.Compat;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class CableDiode
extends BlockContainer
implements IEnergyConnectorBlock,
ILookOverlay,
IToolable,
ITooltipProvider {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;

    public CableDiode(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)));
    }

    @Override
    public boolean canConnect(IBlockAccess world, BlockPos pos, ForgeDirection dir) {
        return true;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, IToolable.ToolType tool) {
        TileEntityDiode te = (TileEntityDiode)world.func_175625_s(new BlockPos(x, y, z));
        if (world.field_72995_K) {
            return true;
        }
        if (tool == IToolable.ToolType.SCREWDRIVER) {
            if (te.level < 17) {
                ++te.level;
            }
            te.func_70296_d();
            INBTPacketReceiver.networkPack(te, te.packValues(), 20);
            return true;
        }
        if (tool == IToolable.ToolType.HAND_DRILL) {
            if (te.level > 1) {
                --te.level;
            }
            te.func_70296_d();
            INBTPacketReceiver.networkPack(te, te.packValues(), 20);
            return true;
        }
        if (tool == IToolable.ToolType.DEFUSER) {
            int p = te.priority.ordinal() + 1;
            if (p >= IEnergyUser.ConnectionPriority.values().length) {
                p = 0;
            }
            te.priority = IEnergyUser.ConnectionPriority.values()[p];
            te.func_70296_d();
            INBTPacketReceiver.networkPack(te, te.packValues(), 20);
            return true;
        }
        return false;
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        this.addStandardInfo(list);
        super.func_190948_a(stack, worldIn, list, flagIn);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileEntityDiode)) {
            return;
        }
        TileEntityDiode diode = (TileEntityDiode)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add("Max.: " + Library.getShortNumber(diode.getMaxPower() * 20L) + "HE/s");
        text.add("Priority: " + diode.priority.name());
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDiode();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public static class TileEntityDiode
    extends TileEntityLoadedBase
    implements ITickable,
    IEnergyUser,
    INBTPacketReceiver {
        int level = 1;
        private long power;
        private boolean recursionBrake = false;
        private int pulses = 0;
        public IEnergyUser.ConnectionPriority priority = IEnergyUser.ConnectionPriority.NORMAL;

        @Override
        public void networkUnpack(NBTTagCompound nbt) {
            this.level = nbt.func_74762_e("level");
            this.priority = IEnergyUser.ConnectionPriority.values()[nbt.func_74771_c("p")];
        }

        public NBTTagCompound packValues() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("level", this.level);
            nbt.func_74774_a("p", (byte)this.priority.ordinal());
            return nbt;
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.level = nbt.func_74762_e("level");
            this.priority = IEnergyUser.ConnectionPriority.values()[nbt.func_74771_c("p")];
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            nbt.func_74768_a("level", this.level);
            nbt.func_74774_a("p", (byte)this.priority.ordinal());
            return nbt;
        }

        public SPacketUpdateTileEntity func_189518_D_() {
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
        }

        public NBTTagCompound func_189517_E_() {
            return this.func_189515_b(new NBTTagCompound());
        }

        public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
        }

        private ForgeDirection getDir() {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            return ForgeDirection.getOrientation(state.func_177230_c().func_176201_c(state)).getOpposite();
        }

        public void func_73660_a() {
            if (!this.field_145850_b.field_72995_K) {
                this.pulses = 0;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (dir == this.getDir()) continue;
                    this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177958_n() + dir.offsetX, this.field_174879_c.func_177956_o() + dir.offsetY, this.field_174879_c.func_177952_p() + dir.offsetZ, dir);
                }
            }
        }

        @Override
        public boolean canConnect(ForgeDirection dir) {
            return dir != this.getDir();
        }

        @Override
        public long transferPower(long power) {
            IEnergyUser rec;
            if (this.recursionBrake) {
                return power;
            }
            ++this.pulses;
            if (this.getPower() >= this.getMaxPower() || this.pulses > 10) {
                return power;
            }
            this.recursionBrake = true;
            ForgeDirection dir = this.getDir();
            Nodespace.PowerNode node = Nodespace.getNode(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ));
            TileEntity te = Compat.getTileStandard(this.field_145850_b, this.field_174879_c.func_177958_n() + dir.offsetX, this.field_174879_c.func_177956_o() + dir.offsetY, this.field_174879_c.func_177952_p() + dir.offsetZ);
            if (node != null && !node.expired && node.hasValidNet() && te instanceof IEnergyConnector && ((IEnergyConnector)te).canConnect(dir.getOpposite())) {
                long toTransfer = Math.min(power, this.getReceiverSpeed());
                long remainder = node.net.sendPowerDiode(toTransfer);
                long transferred = toTransfer - remainder;
                this.power += transferred;
                power -= transferred;
            } else if (te instanceof IEnergyUser && te != this && (rec = (IEnergyUser)te).canConnect(dir.getOpposite())) {
                long toTransfer = Math.min(power, rec.getReceiverSpeed());
                long remainder = rec.transferPower(toTransfer);
                this.recursionBrake = false;
                return power -= toTransfer - remainder;
            }
            this.recursionBrake = false;
            return power;
        }

        @Override
        public long getMaxPower() {
            return (long)Math.pow(10.0, this.level) >> 1;
        }

        @Override
        public long getPower() {
            return Math.min(this.power, this.getMaxPower());
        }

        @Override
        public void setPower(long power) {
            this.power = power;
        }

        @Override
        public IEnergyUser.ConnectionPriority getPriority() {
            return this.priority;
        }
    }
}

