/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IConveyorBelt;
import api.hbm.block.IConveyorItem;
import api.hbm.block.IConveyorPackage;
import api.hbm.block.IEnterableBlock;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.items.tool.ItemTooling;
import com.hbm.main.MainRegistry;
import com.hbm.modules.ModulePatternMatcher;
import com.hbm.tileentity.network.TileEntityCraneRouter;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CraneRouter
extends BlockContainer
implements IEnterableBlock {
    private static EnumFacing[] customEnumOrder = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.UP, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.WEST};

    public CraneRouter(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCraneRouter();
    }

    @Override
    public boolean canItemEnter(World world, int x, int y, int z, EnumFacing dir, IConveyorItem entity) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand).func_77973_b() instanceof ItemTooling) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        if (!playerIn.func_70093_af()) {
            playerIn.openGui((Object)MainRegistry.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public void onItemEnter(World world, int x, int y, int z, EnumFacing dir, IConveyorItem entity) {
        int i;
        TileEntityCraneRouter router = (TileEntityCraneRouter)world.func_175625_s(new BlockPos(x, y, z));
        ItemStack stack = entity.getItemStack();
        ArrayList<EnumFacing> validDirs = new ArrayList<EnumFacing>();
        for (i = 0; i < 6; ++i) {
            ModulePatternMatcher matcher = router.patterns[i];
            int mode = router.modes[i];
            if (mode == 0) continue;
            if (mode == 3) continue;
            boolean matchesFilter = false;
            for (int slot = 0; slot < 5; ++slot) {
                ItemStack filter = router.inventory.getStackInSlot(i * 5 + slot);
                if (filter.func_190926_b() || !matcher.isValidForFilter(filter, slot, stack)) continue;
                matchesFilter = true;
                break;
            }
            if (mode != 1 || !matchesFilter) {
                if (mode != 2 || matchesFilter) continue;
            }
            validDirs.add(customEnumOrder[i]);
        }
        if (validDirs.isEmpty()) {
            for (i = 0; i < 6; ++i) {
                if (router.modes[i] != 3) continue;
                validDirs.add(customEnumOrder[i]);
            }
        }
        if (validDirs.isEmpty()) {
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack.func_77946_l()));
            return;
        }
        i = world.field_73012_v.nextInt(validDirs.size());
        this.sendOnRoute(world, x, y, z, entity, (EnumFacing)validDirs.get(i));
    }

    protected void sendOnRoute(World world, int x, int y, int z, IConveyorItem item, EnumFacing dir) {
        IConveyorBelt belt = null;
        BlockPos targetPos = new BlockPos(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e());
        Block block = world.func_180495_p(targetPos).func_177230_c();
        if (block instanceof IConveyorBelt) {
            belt = (IConveyorBelt)block;
        }
        if (belt != null) {
            EntityMovingItem moving = new EntityMovingItem(world);
            Vec3d pos = new Vec3d((double)x + 0.5 + (double)dir.func_82601_c() * 0.55, (double)y + 0.5 + (double)dir.func_96559_d() * 0.55, (double)z + 0.5 + (double)dir.func_82599_e() * 0.55);
            Vec3d snap = belt.getClosestSnappingPosition(world, targetPos, pos);
            moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
            moving.setItemStack(item.getItemStack());
            world.func_72838_d((Entity)moving);
        } else {
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5 + (double)dir.func_82601_c() * 0.55, (double)y + 0.5 + (double)dir.func_96559_d() * 0.55, (double)z + 0.5 + (double)dir.func_82599_e() * 0.55, item.getItemStack()));
        }
    }

    @Override
    public boolean canPackageEnter(World world, int x, int y, int z, EnumFacing dir, IConveyorPackage entity) {
        return false;
    }

    @Override
    public void onPackageEnter(World world, int x, int y, int z, EnumFacing dir, IConveyorPackage entity) {
    }
}

