/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.HeatRecipes;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityHeatBoiler;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class HeatBoiler
extends BlockDummyable
implements ILookOverlay,
ITooltipProvider {
    public HeatBoiler(Material materialIn, String s) {
        super(materialIn, s);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityHeatBoiler();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(false, false, true);
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{3, 0, 1, 1, 1, 1};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isCore(state) ? Item.func_150898_a((Block)ModBlocks.heat_boiler) : Items.field_190931_a;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModBlocks.heat_boiler);
    }

    public boolean func_180639_a(World world, BlockPos pos1, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof ItemForgeFluidIdentifier) {
                int[] pos = this.findCore((IBlockAccess)world, pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p());
                if (pos == null) {
                    return false;
                }
                TileEntity te = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
                if (!(te instanceof TileEntityHeatBoiler)) {
                    return false;
                }
                TileEntityHeatBoiler boiler = (TileEntityHeatBoiler)te;
                Fluid type = ItemForgeFluidIdentifier.getType(player.func_184586_b(hand));
                if (!HeatRecipes.hasBoilRecipe(type)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cNo recipe found for \u00a7e" + type.getLocalizedName(new FluidStack(type, 1))));
                    return false;
                }
                boiler.setTankType(0, type);
                boiler.func_70296_d();
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7eRecipe changed to \u00a7a" + type.getLocalizedName(new FluidStack(type, 1))));
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, (x += dir.offsetX * o) + rot.offsetX, y, (z += dir.offsetZ * o) + rot.offsetZ);
        this.makeExtra(world, x - rot.offsetX, y, z - rot.offsetZ);
        this.makeExtra(world, x, y + 3, z);
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        this.addStandardInfo(list);
        super.func_190948_a(stack, worldIn, list, flagIn);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore((IBlockAccess)world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (!(te instanceof TileEntityHeatBoiler)) {
            return;
        }
        TileEntityHeatBoiler boiler = (TileEntityHeatBoiler)te;
        ArrayList<String> text = new ArrayList<String>();
        for (int i = 0; i < boiler.types.length; ++i) {
            if (boiler.types[i] == null) continue;
            text.add((i < 1 ? "\u00a7a-> " : "\u00a7c<- ") + "\u00a7r" + boiler.types[i].getLocalizedName(new FluidStack(boiler.types[i], 1)) + ": " + boiler.tanks[i].getFluidAmount() + "/" + boiler.tanks[i].getCapacity() + "mB");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

