/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.MachineConfig;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemLock;
import com.hbm.lib.InventoryHelper;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityCrateDesh;
import com.hbm.tileentity.machine.TileEntityCrateIron;
import com.hbm.tileentity.machine.TileEntityCrateSteel;
import com.hbm.tileentity.machine.TileEntityCrateTungsten;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import com.hbm.tileentity.machine.TileEntitySafe;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockStorageCrate
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static boolean dropInv = true;

    public BlockStorageCrate(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149672_a(SoundType.field_185852_e);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this == ModBlocks.crate_iron) {
            return new TileEntityCrateIron();
        }
        if (this == ModBlocks.crate_steel) {
            return new TileEntityCrateSteel();
        }
        if (this == ModBlocks.crate_tungsten) {
            return new TileEntityCrateTungsten();
        }
        if (this == ModBlocks.crate_desh) {
            return new TileEntityCrateDesh();
        }
        if (this == ModBlocks.safe) {
            return new TileEntitySafe();
        }
        return null;
    }

    public int getSlots() {
        if (this == ModBlocks.crate_iron) {
            return 36;
        }
        if (this == ModBlocks.crate_steel) {
            return 54;
        }
        if (this == ModBlocks.crate_tungsten) {
            return 27;
        }
        if (this == ModBlocks.crate_desh) {
            return 104;
        }
        if (this == ModBlocks.safe) {
            return 15;
        }
        return 0;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            TileEntityLockableBase lockable;
            ItemStack drop = new ItemStack((Block)this);
            TileEntity te = world.func_175625_s(pos);
            NBTTagCompound nbt = new NBTTagCompound();
            if (te != null) {
                IItemHandler inventory = te instanceof TileEntitySafe ? (IItemHandler)((TileEntitySafe)te).getPackingCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) : (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    NBTTagCompound slot = new NBTTagCompound();
                    stack.func_77955_b(slot);
                    nbt.func_74782_a("slot" + i, (NBTBase)slot);
                }
            }
            if (te instanceof TileEntityLockableBase && (lockable = (TileEntityLockableBase)te).isLocked()) {
                nbt.func_74768_a("lock", lockable.getPins());
                nbt.func_74780_a("lockMod", lockable.getMod());
            }
            if (!nbt.func_82582_d()) {
                drop.func_77982_d(nbt);
                if (nbt.toString().length() > MachineConfig.crateByteSize * 1000) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cWarning: Container NBT exceeds " + MachineConfig.crateByteSize + "kB, contents will be ejected!"));
                    InventoryHelper.dropInventoryItems(world, pos, (ICapabilityProvider)world.func_175625_s(pos));
                    InventoryHelper.spawnItemStack(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack(Item.func_150898_a((Block)this)));
                    return world.func_175698_g(pos);
                }
            }
            InventoryHelper.spawnItemStack(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
        }
        dropInv = false;
        boolean flag = world.func_175698_g(pos);
        dropInv = true;
        return flag;
    }

    public Block func_149672_a(SoundType sound) {
        return super.func_149672_a(sound);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (dropInv) {
            InventoryHelper.dropInventoryItems(worldIn, pos, (ICapabilityProvider)worldIn.func_175625_s(pos));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_184614_ca() != null && (player.func_184614_ca().func_77973_b() instanceof ItemLock || player.func_184614_ca().func_77973_b() == ModItems.key_kit)) {
            return false;
        }
        if (!player.func_70093_af()) {
            TileEntity entity = world.func_175625_s(pos);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (entity instanceof TileEntityCrateIron && ((TileEntityCrateIron)entity).canAccess(player)) {
                player.openGui((Object)MainRegistry.instance, 46, world, x, y, z);
            }
            if (entity instanceof TileEntityCrateSteel && ((TileEntityCrateSteel)entity).canAccess(player)) {
                player.openGui((Object)MainRegistry.instance, 47, world, x, y, z);
            }
            if (entity instanceof TileEntityCrateTungsten && ((TileEntityCrateTungsten)entity).canAccess(player)) {
                player.openGui((Object)MainRegistry.instance, 107, world, x, y, z);
            }
            if (entity instanceof TileEntityCrateDesh && ((TileEntityCrateDesh)entity).canAccess(player)) {
                player.openGui((Object)MainRegistry.instance, 128, world, x, y, z);
            }
            if (entity instanceof TileEntitySafe && ((TileEntitySafe)entity).canAccess(player)) {
                player.openGui((Object)MainRegistry.instance, 70, world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && stack.func_77942_o()) {
            IItemHandler inventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            NBTTagCompound nbt = stack.func_77978_p();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                inventory.insertItem(i, new ItemStack(nbt.func_74775_l("slot" + i)), false);
            }
            if (te instanceof TileEntityLockableBase) {
                TileEntityLockableBase lockable = (TileEntityLockableBase)te;
                if (nbt.func_74764_b("lock")) {
                    lockable.setPins(nbt.func_74762_e("lock"));
                    lockable.setMod(nbt.func_74769_h("lockMod"));
                    lockable.lock();
                }
            }
        }
        if (this != ModBlocks.safe) {
            super.func_180633_a(world, pos, state, placer, stack);
        } else {
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, list, flagIn);
        int totalSlots = this.getSlots();
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            int slotCount = 0;
            for (int i = 0; i < totalSlots; ++i) {
                if (!nbt.func_74764_b("slot" + i)) continue;
                ++slotCount;
            }
            float percent = Library.roundFloat((float)slotCount * 100.0f / (float)totalSlots, 1);
            String color = "\u00a7e";
            String color2 = "\u00a76";
            if (percent >= 75.0f) {
                color = "\u00a7c";
                color2 = "\u00a74";
            } else if (percent < 25.0f) {
                color = "\u00a7a";
                color2 = "\u00a72";
            }
            list.add(color + slotCount + color2 + "/" + totalSlots + " Slots used " + color + "(" + percent + "%)\u00a7r");
        } else {
            list.add("\u00a7a0\u00a72/" + totalSlots + " Slots used \u00a7a(0.0%)\u00a7r");
        }
    }
}

