/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ModBlocks;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.IItemHazard;
import com.hbm.interfaces.IRadResistantBlock;
import com.hbm.modules.ItemHazardModule;
import com.hbm.util.I18nUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockNTMGlass
extends BlockBreakable
implements IRadResistantBlock,
IItemHazard {
    BlockRenderLayer layer;
    ItemHazardModule module;
    boolean doesDrop = false;
    boolean isRadResistant = false;

    public BlockNTMGlass(Material materialIn, BlockRenderLayer layer, String s) {
        this(materialIn, layer, false, s);
    }

    public BlockNTMGlass(Material materialIn, BlockRenderLayer layer, boolean doesDrop, String s) {
        this(materialIn, layer, doesDrop, false, s);
    }

    public BlockNTMGlass(Material materialIn, BlockRenderLayer layer, boolean doesDrop, boolean isRadResistant, String s) {
        super(materialIn, false);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.layer = layer;
        this.doesDrop = doesDrop;
        this.isRadResistant = isRadResistant;
        this.module = new ItemHazardModule();
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    @Override
    public ItemHazardModule getModule() {
        return this.module;
    }

    public BlockNTMGlass setSoundType(SoundType sound) {
        return (BlockNTMGlass)super.func_149672_a(sound);
    }

    public int func_149745_a(Random random) {
        return this.doesDrop ? 1 : 0;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isRadResistant) {
            RadiationSystemNT.markChunkForRebuild(worldIn, pos);
        }
        super.func_176213_c(worldIn, pos, state);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isRadResistant) {
            RadiationSystemNT.markChunkForRebuild(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.doesDrop ? 1 : 0;
    }

    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    protected boolean func_149700_E() {
        return false;
    }

    @Override
    public boolean isRadResistant(World worldIn, BlockPos blockPos) {
        return this.isRadResistant;
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        float hardness = this.func_149638_a(null);
        if (this.isRadResistant) {
            tooltip.add("\u00a72[" + I18nUtil.resolveKey("trait.radshield", new Object[0]) + "]");
        }
        if (hardness > 50.0f) {
            tooltip.add("\u00a76" + I18nUtil.resolveKey("trait.blastres", Float.valueOf(hardness)));
        }
    }
}

