/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ModBlocks;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockModDoor
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyEnum<BlockDoor.EnumHingePosition> HINGE = PropertyEnum.func_177709_a((String)"hinge", BlockDoor.EnumHingePosition.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyEnum<BlockDoor.EnumDoorHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockDoor.EnumDoorHalf.class);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);

    public BlockModDoor(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.FALSE).func_177226_a(HINGE, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE).func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER));
        ModBlocks.ALL_BLOCKS.add(this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean flag = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.RIGHT;
        switch (enumfacing) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return BlockModDoor.isOpen(BlockModDoor.combineMetadata(worldIn, pos));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151668_h;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        BlockPos blockpos = state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() != this) {
            return false;
        }
        state = iblockstate.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(blockpos, state, 10);
        worldIn.func_175704_b(blockpos, pos);
        worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), HBMSoundHandler.openDoor, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return true;
    }

    public void toggleDoor(World worldIn, BlockPos pos, boolean open) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == this) {
            IBlockState iblockstate1;
            BlockPos blockpos = iblockstate.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
            IBlockState iBlockState = iblockstate1 = pos == blockpos ? iblockstate : worldIn.func_180495_p(blockpos);
            if (iblockstate1.func_177230_c() == this && (Boolean)iblockstate1.func_177229_b((IProperty)OPEN) != open) {
                worldIn.func_180501_a(blockpos, iblockstate1.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 10);
                worldIn.func_175704_b(blockpos, pos);
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), HBMSoundHandler.openDoor, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos = pos.func_177977_b();
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                iblockstate.func_189546_a(worldIn, blockpos, blockIn, fromPos);
            }
        } else {
            boolean flag1 = false;
            BlockPos blockpos1 = pos.func_177984_a();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                flag1 = true;
            }
            if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
                worldIn.func_175698_g(pos);
                flag1 = true;
                if (iblockstate1.func_177230_c() == this) {
                    worldIn.func_175698_g(blockpos1);
                }
            }
            if (flag1) {
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                boolean flag;
                boolean bl = flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos1);
                if (blockIn != this && (flag || blockIn.func_176223_P().func_185897_m()) && flag != (Boolean)iblockstate1.func_177229_b((IProperty)POWERED)) {
                    worldIn.func_180501_a(blockpos1, iblockstate1.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.func_177229_b((IProperty)OPEN)) {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
                        worldIn.func_175704_b(pos, pos);
                        worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), HBMSoundHandler.openDoor, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    }
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.getItem();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (pos.func_177956_o() >= worldIn.func_72800_K() - 1) {
            return false;
        }
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return (state.func_185896_q() || state.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID) && super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public static int combineMetadata(IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        int i = iblockstate.func_177230_c().func_176201_c(iblockstate);
        boolean flag = BlockModDoor.isTop(i);
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
        int j = iblockstate1.func_177230_c().func_176201_c(iblockstate1);
        int k = flag ? j : i;
        IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177984_a());
        int l = iblockstate2.func_177230_c().func_176201_c(iblockstate2);
        int i1 = flag ? i : l;
        boolean flag1 = (i1 & 1) != 0;
        boolean flag2 = (i1 & 2) != 0;
        return BlockModDoor.removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getItem());
    }

    private Item getItem() {
        if (this == ModBlocks.door_metal) {
            return ModItems.door_metal;
        }
        if (this == ModBlocks.door_office) {
            return ModItems.door_office;
        }
        return ModItems.door_bunker;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.func_177977_b();
        BlockPos blockpos1 = pos.func_177984_a();
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER && worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(blockpos1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
            if (iblockstate.func_177230_c() == this) {
                state = state.func_177226_a(HINGE, iblockstate.func_177229_b(HINGE)).func_177226_a((IProperty)POWERED, iblockstate.func_177229_b((IProperty)POWERED));
            }
        } else {
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
            if (iblockstate1.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)FACING, iblockstate1.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)OPEN, iblockstate1.func_177229_b((IProperty)OPEN));
            }
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177229_b(HALF) != BlockDoor.EnumDoorHalf.LOWER ? state : state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a(HINGE, (Comparable)((meta & 1) > 0 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 2) > 0)) : this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            i |= 8;
            if (state.func_177229_b(HINGE) == BlockDoor.EnumHingePosition.RIGHT) {
                i |= 1;
            }
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                i |= 2;
            }
        } else {
            i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e().func_176736_b();
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    protected static int removeHalfBit(int meta) {
        return meta & 7;
    }

    public static boolean isOpen(IBlockAccess worldIn, BlockPos pos) {
        return BlockModDoor.isOpen(BlockModDoor.combineMetadata(worldIn, pos));
    }

    public static EnumFacing getFacing(IBlockAccess worldIn, BlockPos pos) {
        return BlockModDoor.getFacing(BlockModDoor.combineMetadata(worldIn, pos));
    }

    public static EnumFacing getFacing(int combinedMeta) {
        return EnumFacing.func_176731_b((int)(combinedMeta & 3)).func_176735_f();
    }

    protected static boolean isOpen(int combinedMeta) {
        return (combinedMeta & 4) != 0;
    }

    protected static boolean isTop(int meta) {
        return (meta & 8) != 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, FACING, OPEN, HINGE, POWERED});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

