/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.animloader;

import com.hbm.animloader.AnimatedModel;
import com.hbm.animloader.Animation;
import com.hbm.animloader.AnimationController;
import com.hbm.animloader.Transform;
import com.hbm.main.MainRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@SideOnly(value=Side.CLIENT)
public class ColladaLoader {
    public static AnimatedModel load(ResourceLocation file) {
        return ColladaLoader.load(file, false);
    }

    public static AnimatedModel load(ResourceLocation file, boolean flipV) {
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(file);
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(res.func_110527_b());
                return ColladaLoader.parse(doc.getDocumentElement(), flipV);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MainRegistry.logger.log(Level.ERROR, "FAILED TO LOAD MODEL: " + file);
        return null;
    }

    private static AnimatedModel parse(Element root, boolean flipV) {
        Element scene = ColladaLoader.getFirstElement((Element)root.getElementsByTagName("library_visual_scenes").item(0));
        AnimatedModel structure = new AnimatedModel(){

            @Override
            protected void renderWithIndex(float inter, int firstIndex, int nextIndex, float diffN, AnimatedModel.IAnimatedModelCallback c) {
                for (AnimatedModel m : this.children) {
                    m.renderWithIndex(inter, firstIndex, nextIndex, diffN, c);
                }
            }

            @Override
            public void render() {
                for (AnimatedModel m : this.children) {
                    m.render();
                }
            }
        };
        for (Element node : ColladaLoader.getChildElements(scene)) {
            if (node.getElementsByTagName("instance_geometry").getLength() <= 0) continue;
            structure.children.add(ColladaLoader.parseStructure(node));
        }
        Map<String, Integer> geometry = ColladaLoader.parseGeometry((Element)root.getElementsByTagName("library_geometries").item(0), flipV);
        ColladaLoader.addGeometry(structure, geometry);
        ColladaLoader.setAnimationController(structure, new AnimationController());
        return structure;
    }

    private static void setAnimationController(AnimatedModel model, AnimationController control) {
        model.controller = control;
        for (AnimatedModel m : model.children) {
            ColladaLoader.setAnimationController(m, control);
        }
    }

    private static Element getFirstElement(Node root) {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    private static List<Element> getElementsByName(Element e, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList n = e.getChildNodes();
        for (int i = 0; i < n.getLength(); ++i) {
            Node node = n.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    private static List<Element> getChildElements(Element e) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (e == null) {
            return elements;
        }
        NodeList n = e.getChildNodes();
        for (int i = 0; i < n.getLength(); ++i) {
            Node node = n.item(i);
            if (node.getNodeType() != 1) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    private static AnimatedModel parseStructure(Element root) {
        AnimatedModel model = new AnimatedModel();
        model.name = root.getAttribute("name");
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element ele = (Element)node;
            if ("transform".equals(ele.getAttribute("sid"))) {
                model.transform = ColladaLoader.flipMatrix(ColladaLoader.parseFloatArray(ele.getTextContent()));
                model.hasTransform = true;
                continue;
            }
            if ("instance_geometry".equals(ele.getTagName())) {
                model.geo_name = ele.getAttribute("url").substring(1);
                continue;
            }
            if (ele.getElementsByTagName("instance_geometry").getLength() <= 0) continue;
            AnimatedModel childModel = ColladaLoader.parseStructure(ele);
            childModel.parent = model;
            model.children.add(childModel);
        }
        return model;
    }

    private static Map<String, Integer> parseGeometry(Element root, boolean flipV) {
        HashMap<String, Integer> allGeometry = new HashMap<String, Integer>();
        for (Element e : ColladaLoader.getElementsByName(root, "geometry")) {
            String name = e.getAttribute("id");
            Element mesh = ColladaLoader.getElementsByName(e, "mesh").get(0);
            float[] positions = new float[]{};
            float[] normals = new float[]{};
            float[] texCoords = new float[]{};
            int[] indices = new int[]{};
            for (Element section : ColladaLoader.getChildElements(mesh)) {
                String id = section.getAttribute("id");
                if (id.endsWith("mesh-positions")) {
                    positions = ColladaLoader.parsePositions(section);
                    continue;
                }
                if (id.endsWith("mesh-normals")) {
                    normals = ColladaLoader.parseNormals(section);
                    continue;
                }
                if (id.endsWith("mesh-map-0")) {
                    texCoords = ColladaLoader.parseTexCoords(section);
                    continue;
                }
                if (!section.getNodeName().equals("triangles")) continue;
                indices = ArrayUtils.addAll((int[])indices, (int[])ColladaLoader.parseIndices(section));
            }
            if (positions.length == 0) continue;
            int displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayList, (int)4864);
            BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
            buf.func_181668_a(4, DefaultVertexFormats.field_181710_j);
            if (indices.length > 0) {
                for (int i = 0; i < indices.length; i += 3) {
                    float v = texCoords[indices[i + 2] * 2 + 1];
                    if (flipV) {
                        v = 1.0f - v;
                    }
                    buf.func_181662_b((double)positions[indices[i] * 3], (double)positions[indices[i] * 3 + 1], (double)positions[indices[i] * 3 + 2]).func_187315_a((double)texCoords[indices[i + 2] * 2], (double)v).func_181663_c(normals[indices[i + 1] * 3], normals[indices[i + 1] * 3 + 1], normals[indices[i + 1] * 3 + 2]).func_181675_d();
                }
            }
            Tessellator.func_178181_a().func_78381_a();
            GL11.glEndList();
            allGeometry.put(name, displayList);
        }
        return allGeometry;
    }

    private static float[] parsePositions(Element root) {
        String content = root.getElementsByTagName("float_array").item(0).getTextContent();
        return ColladaLoader.parseFloatArray(content);
    }

    private static float[] parseNormals(Element root) {
        String content = root.getElementsByTagName("float_array").item(0).getTextContent();
        return ColladaLoader.parseFloatArray(content);
    }

    private static float[] parseTexCoords(Element root) {
        String content = root.getElementsByTagName("float_array").item(0).getTextContent();
        return ColladaLoader.parseFloatArray(content);
    }

    private static int[] parseIndices(Element root) {
        String content = root.getElementsByTagName("p").item(0).getTextContent();
        return ColladaLoader.parseIntegerArray(content);
    }

    private static float[] parseFloatArray(String s) {
        if (s.isEmpty()) {
            return new float[0];
        }
        String[] numbers = s.split(" ");
        float[] arr = new float[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            arr[i] = Float.parseFloat(numbers[i]);
        }
        return arr;
    }

    private static int[] parseIntegerArray(String s) {
        String[] numbers = s.split(" ");
        int[] arr = new int[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            arr[i] = Integer.parseInt(numbers[i]);
        }
        return arr;
    }

    private static void addGeometry(AnimatedModel m, Map<String, Integer> geometry) {
        if (!"".equals(m.geo_name) && geometry.containsKey(m.geo_name)) {
            m.callList = geometry.get(m.geo_name);
        } else {
            m.hasGeometry = false;
            m.callList = -1;
        }
        for (AnimatedModel child : m.children) {
            ColladaLoader.addGeometry(child, geometry);
        }
    }

    public static Animation loadAnim(int length, ResourceLocation file) {
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(file);
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(res.func_110527_b());
                return ColladaLoader.parseAnim(doc.getDocumentElement(), length);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MainRegistry.logger.log(Level.ERROR, "FAILED TO LOAD MODEL: " + file);
        return null;
    }

    private static Animation parseAnim(Element root, int length) {
        Element anim_section = (Element)root.getElementsByTagName("library_animations").item(0);
        Animation anim = new Animation();
        anim.length = length;
        for (Element e : ColladaLoader.getChildElements(anim_section)) {
            if (!"animation".equals(e.getNodeName())) continue;
            String name = e.getAttribute("name");
            Transform[] t = null;
            List<Element> elements2 = ColladaLoader.getChildElements(e);
            if (elements2.isEmpty()) continue;
            for (Element e2 : elements2) {
                if (e2.getAttribute("id").endsWith("transform")) {
                    t = ColladaLoader.parseTransforms(e2);
                    continue;
                }
                if (!e2.getAttribute("id").endsWith("hide_viewport")) continue;
                ColladaLoader.setViewportHiddenKeyframes(t, e2);
            }
            anim.objectTransforms.put(name, t);
            anim.numKeyFrames = t.length;
        }
        return anim;
    }

    private static Transform[] parseTransforms(Element root) {
        String output = ColladaLoader.getOutputLocation(root);
        for (Element e : ColladaLoader.getChildElements(root)) {
            if (!e.getAttribute("id").equals(output)) continue;
            return ColladaLoader.parseTransformsFromText(e.getElementsByTagName("float_array").item(0).getTextContent());
        }
        System.out.println("Failed to parse transforms! This will not work!");
        System.out.println("Node name: " + root.getTagName());
        return null;
    }

    private static void setViewportHiddenKeyframes(Transform[] t, Element root) {
        String output = ColladaLoader.getOutputLocation(root);
        for (Element e : ColladaLoader.getChildElements(root)) {
            if (!e.getAttribute("id").equals(output)) continue;
            int[] hiddenFrames = ColladaLoader.parseIntegerArray(e.getElementsByTagName("float_array").item(0).getTextContent());
            for (int i = 0; i < hiddenFrames.length; ++i) {
                t[i].hidden = hiddenFrames[i] > 0;
            }
        }
    }

    private static String getOutputLocation(Element root) {
        Element sampler = (Element)root.getElementsByTagName("sampler").item(0);
        for (Element e : ColladaLoader.getChildElements(sampler)) {
            if (!"OUTPUT".equals(e.getAttribute("semantic"))) continue;
            return e.getAttribute("source").substring(1);
        }
        return null;
    }

    private static Transform[] parseTransformsFromText(String data) {
        float[] floats = ColladaLoader.parseFloatArray(data);
        Transform[] transforms = new Transform[floats.length / 16];
        for (int i = 0; i < floats.length / 16; ++i) {
            float[] rawTransform = new float[16];
            for (int j = 0; j < 16; ++j) {
                rawTransform[j] = floats[i * 16 + j];
            }
            transforms[i] = new Transform(rawTransform);
        }
        return transforms;
    }

    private static float[] flipMatrix(float[] f) {
        if (f.length != 16) {
            System.out.println("Error flipping matrix: array length not 16. This will not work!");
            System.out.println("Matrix: " + f);
        }
        return new float[]{f[0], f[4], f[8], f[12], f[1], f[5], f[9], f[13], f[2], f[6], f[10], f[14], f[3], f[7], f[11], f[15]};
    }
}

