/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.energy.IEnergyUser;
import api.hbm.energy.Nodespace;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PowerNet {
    public boolean valid = true;
    public Set<Nodespace.PowerNode> links = new HashSet<Nodespace.PowerNode>();
    public HashMap<IEnergyUser, Long> receiverEntries = new HashMap();
    public HashMap<IEnergyGenerator, Long> providerEntries = new HashMap();
    public long energyTracker = 0L;
    protected static int timeout = 3000;

    public PowerNet() {
        Nodespace.activePowerNets.add(this);
    }

    public void addReceiver(IEnergyUser receiver) {
        this.receiverEntries.put(receiver, System.currentTimeMillis());
    }

    public void removeReceiver(IEnergyUser receiver) {
        this.receiverEntries.remove(receiver);
    }

    public void addProvider(IEnergyGenerator provider) {
        this.providerEntries.put(provider, System.currentTimeMillis());
    }

    public void removeProvider(IEnergyGenerator provider) {
        this.providerEntries.remove(provider);
    }

    public void joinNetworks(PowerNet network) {
        if (network == this) {
            return;
        }
        ArrayList<Nodespace.PowerNode> oldNodes = new ArrayList<Nodespace.PowerNode>(network.links.size());
        oldNodes.addAll(network.links);
        for (Nodespace.PowerNode powerNode : oldNodes) {
            this.forceJoinLink(powerNode);
        }
        network.links.clear();
        for (IEnergyUser iEnergyUser : network.receiverEntries.keySet()) {
            this.addReceiver(iEnergyUser);
        }
        for (IEnergyGenerator iEnergyGenerator : network.providerEntries.keySet()) {
            this.addProvider(iEnergyGenerator);
        }
        network.destroy();
    }

    public PowerNet joinLink(Nodespace.PowerNode node) {
        if (node.net != null) {
            node.net.leaveLink(node);
        }
        return this.forceJoinLink(node);
    }

    public PowerNet forceJoinLink(Nodespace.PowerNode node) {
        this.links.add(node);
        node.setNet(this);
        return this;
    }

    public void leaveLink(Nodespace.PowerNode node) {
        node.setNet(null);
        this.links.remove(node);
    }

    public void invalidate() {
        this.valid = false;
        Nodespace.activePowerNets.remove(this);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void destroy() {
        this.invalidate();
        for (Nodespace.PowerNode link : this.links) {
            if (link.net != this) continue;
            link.setNet(null);
        }
        this.links.clear();
        this.receiverEntries.clear();
        this.providerEntries.clear();
    }

    public void resetEnergyTracker() {
        this.energyTracker = 0L;
    }

    public void transferPower() {
        if (this.providerEntries.isEmpty()) {
            return;
        }
        if (this.receiverEntries.isEmpty()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        long transferCap = 10000000000000000L;
        ArrayList<Tuple.Pair<IEnergyGenerator, Long>> providers = new ArrayList<Tuple.Pair<IEnergyGenerator, Long>>();
        long powerAvailable = 0L;
        Iterator<Map.Entry<IEnergyGenerator, Long>> provIt = this.providerEntries.entrySet().iterator();
        while (provIt.hasNext()) {
            Map.Entry<IEnergyGenerator, Long> entry = provIt.next();
            if (timestamp - entry.getValue() > (long)timeout) {
                provIt.remove();
                continue;
            }
            long src = Math.min(entry.getKey().getPower(), entry.getKey().getProviderSpeed());
            providers.add(new Tuple.Pair<IEnergyGenerator, Long>(entry.getKey(), src));
            powerAvailable = Math.min(powerAvailable + src, Long.MAX_VALUE);
        }
        ArrayList[] receivers = new ArrayList[IEnergyUser.ConnectionPriority.values().length];
        for (int i = 0; i < receivers.length; ++i) {
            receivers[i] = new ArrayList();
        }
        long[] demand = new long[IEnergyUser.ConnectionPriority.values().length];
        long totalDemand = 0L;
        Iterator<Map.Entry<IEnergyUser, Long>> recIt = this.receiverEntries.entrySet().iterator();
        while (recIt.hasNext()) {
            Map.Entry<IEnergyUser, Long> entry = recIt.next();
            if (timestamp - entry.getValue() > (long)timeout) {
                recIt.remove();
                continue;
            }
            long rec = Math.min(entry.getKey().getMaxPower() - entry.getKey().getPower(), entry.getKey().getReceiverSpeed());
            int p = entry.getKey().getPriority().ordinal();
            receivers[p].add(new Tuple.Pair<IEnergyUser, Long>(entry.getKey(), rec));
            int n = p;
            demand[n] = demand[n] + rec;
            totalDemand += rec;
        }
        long toTransfer = Math.min(Math.min(powerAvailable, transferCap), totalDemand);
        long energyUsed = 0L;
        for (int i = IEnergyUser.ConnectionPriority.values().length - 1; i >= 0; --i) {
            ArrayList arrayList = receivers[i];
            long priorityDemand = demand[i];
            for (Tuple.Pair entry : arrayList) {
                double weight = (double)((Long)entry.getValue()).longValue() / (double)priorityDemand;
                long toSend = (long)Math.max((double)toTransfer * weight, 0.0);
                energyUsed += toSend - ((IEnergyUser)entry.getKey()).transferPower(toSend);
            }
            toTransfer -= energyUsed;
        }
        this.energyTracker += energyUsed;
        for (Tuple.Pair pair : providers) {
            double weight = (double)((Long)pair.getValue()).longValue() / (double)powerAvailable;
            long toUse = (long)Math.max((double)energyUsed * weight, 0.0);
            ((IEnergyGenerator)pair.getKey()).usePower(toUse);
        }
    }

    public long sendPowerDiode(long power) {
        if (this.receiverEntries.isEmpty()) {
            return power;
        }
        long timestamp = System.currentTimeMillis();
        ArrayList[] receivers = new ArrayList[IEnergyUser.ConnectionPriority.values().length];
        for (int i = 0; i < receivers.length; ++i) {
            receivers[i] = new ArrayList();
        }
        long[] demand = new long[IEnergyUser.ConnectionPriority.values().length];
        long totalDemand = 0L;
        Iterator<Map.Entry<IEnergyUser, Long>> recIt = this.receiverEntries.entrySet().iterator();
        while (recIt.hasNext()) {
            Map.Entry<IEnergyUser, Long> entry = recIt.next();
            if (timestamp - entry.getValue() > (long)timeout) {
                recIt.remove();
                continue;
            }
            long rec = Math.min(entry.getKey().getMaxPower() - entry.getKey().getPower(), entry.getKey().getReceiverSpeed());
            int p = entry.getKey().getPriority().ordinal();
            receivers[p].add(new Tuple.Pair<IEnergyUser, Long>(entry.getKey(), rec));
            int n = p;
            demand[n] = demand[n] + rec;
            totalDemand += rec;
        }
        long toTransfer = Math.min(power, totalDemand);
        long energyUsed = 0L;
        for (int i = IEnergyUser.ConnectionPriority.values().length - 1; i >= 0; --i) {
            ArrayList list = receivers[i];
            long priorityDemand = demand[i];
            for (Tuple.Pair entry : list) {
                double weight = (double)((Long)entry.getValue()).longValue() / (double)priorityDemand;
                long toSend = (long)Math.max((double)toTransfer * weight, 0.0);
                energyUsed += toSend - ((IEnergyUser)entry.getKey()).transferPower(toSend);
            }
            toTransfer -= energyUsed;
        }
        this.energyTracker += energyUsed;
        return power - energyUsed;
    }
}

