/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.PowerNet;
import com.hbm.lib.DirPos;
import com.hbm.tileentity.network.energy.TileEntityCableBaseNT;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Nodespace {
    public static HashMap<World, NodeWorld> worlds = new HashMap();
    public static Set<PowerNet> activePowerNets = new HashSet<PowerNet>();

    public static PowerNode getNode(World world, BlockPos pos) {
        NodeWorld nodeWorld = worlds.get(world);
        if (nodeWorld == null) {
            nodeWorld = new NodeWorld();
            worlds.put(world, nodeWorld);
        }
        if (!nodeWorld.nodes.containsKey(pos)) {
            TileEntity te = world.func_175625_s(pos);
            PowerNode node = null;
            if (te instanceof TileEntityCableBaseNT) {
                TileEntityCableBaseNT connector = (TileEntityCableBaseNT)te;
                node = connector.getNode();
            }
            if (node != null) {
                nodeWorld.pushNode(node);
            } else {
                nodeWorld.nodes.put(pos, null);
            }
        }
        return nodeWorld.nodes.get(pos);
    }

    public static void createNode(World world, PowerNode node) {
        NodeWorld nodeWorld = worlds.get(world);
        if (nodeWorld == null) {
            nodeWorld = new NodeWorld();
            worlds.put(world, nodeWorld);
        }
        nodeWorld.pushNode(node);
    }

    public static void destroyNode(World world, BlockPos pos) {
        PowerNode node = Nodespace.getNode(world, pos);
        if (node != null) {
            worlds.get(world).popNode(node);
        }
    }

    public static void updateNodespace() {
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            NodeWorld nodes = worlds.get(world);
            if (nodes == null) continue;
            for (Map.Entry<BlockPos, PowerNode> entry : new HashMap<BlockPos, PowerNode>(nodes.nodes).entrySet()) {
                PowerNode node = entry.getValue();
                if (node == null || node.hasValidNet() && !node.recentlyChanged) continue;
                Nodespace.checkNodeConnection((World)world, node);
                node.recentlyChanged = false;
            }
        }
        Nodespace.updatePowerNets();
    }

    private static void updatePowerNets() {
        for (PowerNet net : activePowerNets) {
            net.resetEnergyTracker();
        }
        for (PowerNet net : activePowerNets) {
            net.transferPower();
        }
    }

    private static void checkNodeConnection(World world, PowerNode node) {
        for (DirPos con : node.connections) {
            PowerNode conNode = Nodespace.getNode(world, con.getPos());
            if (conNode == null || conNode.hasValidNet() && conNode.net == node.net || !Nodespace.checkConnection(conNode, con, false)) continue;
            Nodespace.connectToNode(node, conNode);
        }
        if (node.net == null || !node.net.isValid()) {
            new PowerNet().joinLink(node);
        }
    }

    public static boolean checkConnection(PowerNode connectsTo, DirPos connectFrom, boolean skipSideCheck) {
        for (DirPos revCon : connectsTo.connections) {
            if (revCon.getPos().func_177958_n() - revCon.getDir().offsetX != connectFrom.getPos().func_177958_n() || revCon.getPos().func_177956_o() - revCon.getDir().offsetY != connectFrom.getPos().func_177956_o() || revCon.getPos().func_177952_p() - revCon.getDir().offsetZ != connectFrom.getPos().func_177952_p() || revCon.getDir() != connectFrom.getDir().getOpposite() && !skipSideCheck) continue;
            return true;
        }
        return false;
    }

    private static void connectToNode(PowerNode origin, PowerNode connection) {
        if (origin.hasValidNet() && connection.hasValidNet()) {
            if (origin.net.links.size() > connection.net.links.size()) {
                origin.net.joinNetworks(connection.net);
            } else {
                connection.net.joinNetworks(origin.net);
            }
        } else if (!origin.hasValidNet() && connection.hasValidNet()) {
            connection.net.joinLink(origin);
        } else if (origin.hasValidNet() && !connection.hasValidNet()) {
            origin.net.joinLink(connection);
        }
    }

    public static class PowerNode {
        public BlockPos[] positions;
        public DirPos[] connections;
        public PowerNet net;
        public boolean expired = false;
        public boolean recentlyChanged = true;

        public PowerNode(BlockPos ... positions) {
            this.positions = positions;
        }

        public PowerNode setConnections(DirPos ... connections) {
            this.connections = connections;
            return this;
        }

        public PowerNode addConnection(DirPos connection) {
            DirPos[] newCons = new DirPos[this.connections.length + 1];
            for (int i = 0; i < this.connections.length; ++i) {
                newCons[i] = this.connections[i];
            }
            newCons[newCons.length - 1] = connection;
            this.connections = newCons;
            return this;
        }

        public boolean hasValidNet() {
            return this.net != null && this.net.isValid();
        }

        public void setNet(PowerNet net) {
            this.net = net;
            this.recentlyChanged = true;
        }
    }

    public static class NodeWorld {
        public HashMap<BlockPos, PowerNode> nodes = new HashMap();

        public void pushNode(PowerNode node) {
            for (BlockPos pos : node.positions) {
                this.nodes.put(pos, node);
            }
        }

        public void popNode(PowerNode node) {
            if (node.net != null) {
                node.net.destroy();
            }
            for (BlockPos pos : node.positions) {
                this.nodes.remove(pos);
                node.expired = true;
            }
        }

        public void popNode(BlockPos pos) {
            PowerNode node = this.nodes.get(pos);
            if (node != null) {
                this.popNode(node);
            }
        }
    }
}

