/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyHandler;
import api.hbm.energy.Nodespace;
import com.hbm.lib.ForgeDirection;
import com.hbm.util.Compat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IEnergyUser
extends IEnergyHandler {
    default public long transferPower(long power) {
        if (power + this.getPower() <= this.getMaxPower()) {
            this.setPower(power + this.getPower());
            return 0L;
        }
        long capacity = this.getMaxPower() - this.getPower();
        long overshoot = power - capacity;
        this.setPower(this.getMaxPower());
        return overshoot;
    }

    default public long getReceiverSpeed() {
        return this.getMaxPower();
    }

    default public void trySubscribe(World world, BlockPos pos, ForgeDirection dir) {
        this.trySubscribe(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dir);
    }

    default public void trySubscribe(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity te = Compat.getTileStandard(world, x, y, z);
        boolean red = false;
        if (te instanceof IEnergyConductor) {
            IEnergyConductor con = (IEnergyConductor)te;
            if (!con.canConnect(dir.getOpposite())) {
                return;
            }
            Nodespace.PowerNode node = Nodespace.getNode(world, new BlockPos(x, y, z));
            if (node != null && node.net != null) {
                node.net.addReceiver(this);
                red = true;
            }
        }
    }

    default public void tryUnsubscribe(World world, int x, int y, int z) {
        IEnergyConductor con;
        Nodespace.PowerNode node;
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof IEnergyConductor && (node = (con = (IEnergyConductor)te).createNode()) != null && node.net != null) {
            node.net.removeReceiver(this);
        }
    }

    default public void updateStandardConnections(World world, TileEntity te) {
        this.updateStandardConnections(world, te.func_174877_v());
    }

    default public void updateStandardConnections(World world, BlockPos pos) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(world, pos.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ), dir);
        }
    }

    default public void updateConnectionsExcept(World world, BlockPos pos, ForgeDirection nogo) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir == nogo) continue;
            this.trySubscribe(world, pos.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ), dir);
        }
    }

    default public ConnectionPriority getPriority() {
        return ConnectionPriority.NORMAL;
    }

    public static enum ConnectionPriority {
        LOWEST,
        LOW,
        NORMAL,
        HIGH,
        HIGHEST;

    }
}

