/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyHandler;
import api.hbm.energy.IEnergyUser;
import api.hbm.energy.Nodespace;
import com.hbm.lib.ForgeDirection;
import com.hbm.util.Compat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IEnergyGenerator
extends IEnergyHandler {
    default public void usePower(long power) {
        this.setPower(this.getPower() - power);
    }

    default public long getProviderSpeed() {
        return this.getMaxPower();
    }

    default public void sendPower(World world, BlockPos pos, ForgeDirection dir) {
        IEnergyUser rec;
        Nodespace.PowerNode node;
        IEnergyConductor con;
        TileEntity te = Compat.getTileStandard(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        boolean red = false;
        if (te instanceof IEnergyConductor && (con = (IEnergyConductor)te).canConnect(dir.getOpposite()) && (node = Nodespace.getNode(world, pos)) != null && node.net != null) {
            node.net.addProvider(this);
            red = true;
        }
        if (te instanceof IEnergyUser && te != this && (rec = (IEnergyUser)te).canConnect(dir.getOpposite())) {
            long provides = Math.min(this.getPower(), this.getProviderSpeed());
            long receives = Math.min(rec.getMaxPower() - rec.getPower(), rec.getReceiverSpeed());
            long toTransfer = Math.min(provides, receives);
            toTransfer -= rec.transferPower(toTransfer);
            this.usePower(toTransfer);
        }
    }

    default public void sendPower(World world, BlockPos pos) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.sendPower(world, pos.func_177982_a(dir.offsetX, dir.offsetY, dir.offsetZ), dir);
        }
    }
}

